/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.service;

import javax.ws.rs.core.Response;
import org.eclipse.dirigible.commons.api.service.IRestService;
import org.slf4j.Logger;

public abstract class AbstractRestService
implements IRestService {
    public static final String NO_LOGGED_IN_USER = "No logged in user";

    protected abstract Logger getLogger();

    protected Response createErrorResponse(Response.Status status, String message) {
        return Response.serverError().status(status).entity((Object)message).build();
    }

    protected Response createErrorResponseNotFound(String message) {
        return this.createErrorResponse(Response.Status.NOT_FOUND, message);
    }

    protected Response createErrorResponseForbidden(String message) {
        return this.createErrorResponse(Response.Status.FORBIDDEN, message);
    }

    protected Response createErrorResponseBadRequest(String message) {
        return this.createErrorResponse(Response.Status.BAD_REQUEST, message);
    }

    protected Response createErrorResponseUnauthorized(String message) {
        return this.createErrorResponse(Response.Status.UNAUTHORIZED, message);
    }

    protected Response createErrorResponseInternalServerError(String message) {
        return this.createErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, message);
    }
}

