/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.dirigible.commons.api.topology.ITopologicallySortable;
import org.eclipse.dirigible.commons.api.topology.TopologicalSorterNode;

public class TopologicalSorter<T extends ITopologicallySortable> {
    private Stack<TopologicalSorterNode<T>> stack = new Stack();

    public List<T> sort(List<T> list) {
        HashMap nodes = new HashMap();
        for (ITopologicallySortable sortable : list) {
            TopologicalSorterNode<ITopologicallySortable> topologicalSorterNode = new TopologicalSorterNode<ITopologicallySortable>(sortable, nodes);
            nodes.put(sortable.getId(), topologicalSorterNode);
        }
        for (TopologicalSorterNode node : nodes.values()) {
            this.topologicalSort(node);
        }
        ArrayList results = new ArrayList();
        for (TopologicalSorterNode topologicalSorterNode : this.stack) {
            results.add(topologicalSorterNode.getData());
        }
        return results;
    }

    private void topologicalSort(TopologicalSorterNode<T> node) {
        List<TopologicalSorterNode<T>> dependencies = node.getDependencies();
        for (int i = 0; i < dependencies.size(); ++i) {
            TopologicalSorterNode<T> n = dependencies.get(i);
            if (n == null || n.isVisited()) continue;
            n.setVisited(true);
            this.topologicalSort(n);
        }
        if (!this.stack.contains(node)) {
            this.stack.push(node);
        }
    }
}

