/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.topology;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.commons.api.topology.ITopologicallySortable;

public class TopologicalSorterNode<T extends ITopologicallySortable> {
    private T data;
    private Map<String, TopologicalSorterNode<T>> nodes;
    private boolean visited;
    private List<TopologicalSorterNode<T>> dependencies;

    public TopologicalSorterNode(T data, Map<String, TopologicalSorterNode<T>> nodes) {
        this.data = data;
        this.nodes = nodes;
    }

    public T getData() {
        return this.data;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public List<TopologicalSorterNode<T>> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<TopologicalSorterNode<T>>();
            for (ITopologicallySortable sortable : this.data.getDependencies()) {
                this.dependencies.add(this.nodes.get(sortable.getId()));
            }
        }
        return this.dependencies;
    }

    public void setDependencies(List<TopologicalSorterNode<T>> dependencies) {
        this.dependencies = dependencies;
    }

    public String toString() {
        return this.data.getId();
    }
}

