/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.service;

import com.google.gson.Gson;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.eclipse.dirigible.commons.api.helpers.AppExceptionMessage;
import org.eclipse.dirigible.commons.api.service.IRestExceptionHandler;
import org.slf4j.Logger;

public abstract class AbstractExceptionHandler<T extends Throwable>
implements ExceptionMapper<T>,
IRestExceptionHandler<T> {
    private static final Gson GSON = new Gson();

    @Override
    public Response toResponse(T exception) {
        this.logErrorMessage(this.getLogger(), exception);
        Response.Status status = this.getResponseStatus(exception);
        String message = this.getResponseMessage(exception);
        AppExceptionMessage appException = new AppExceptionMessage(status, message);
        return Response.status((Response.Status)status).type("application/json").entity((Object)GSON.toJson((Object)appException)).build();
    }

    protected void logErrorMessage(Logger logger, T exception) {
        if (logger.isErrorEnabled()) {
            logger.error(((Throwable)exception).getMessage(), exception);
        }
    }

    @Override
    public abstract Class<? extends AbstractExceptionHandler<T>> getType();

    protected abstract Logger getLogger();

    protected abstract Response.Status getResponseStatus(T var1);

    protected abstract String getResponseMessage(T var1);
}

