/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.config;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.dirigible.commons.config.DirigibleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static final String MULTIVARIABLE_REGEX = "\\$\\{([^}]+)\\}";
    private static final Pattern MULTIVARIABLE_PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final Map<String, String> RUNTIME_VARIABLES = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> ENVIRONMENT_VARIABLES = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> DEPLOYMENT_VARIABLES = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> MODULE_VARIABLES = Collections.synchronizedMap(new HashMap());
    private static final String CONFIG_FILE_PATH_DIRIGIBLE_PROPERTIES = "/dirigible.properties";
    private static final String ERROR_MESSAGE_CONFIGURATION_DOES_NOT_EXIST = "Configuration file {0} does not exist";
    private static final String[] CONFIGURATION_PARAMETERS = Configuration.getConfigParams();
    public static boolean LOADED = false;

    private static String[] getConfigParams() {
        List<String> staticParams = List.of("DIRIGIBLE_ANONYMOUS_USER_NAME_PROPERTY_NAME", "DIRIGIBLE_BRANDING_NAME", "DIRIGIBLE_BRANDING_BRAND", "DIRIGIBLE_BRANDING_ICON", "DIRIGIBLE_BRANDING_WELCOME_PAGE_DEFAULT", "DIRIGIBLE_GIT_ROOT_FOLDER", "DIRIGIBLE_REGISTRY_EXTERNAL_FOLDER", "DIRIGIBLE_REGISTRY_IMPORT_WORKSPACE", "DIRIGIBLE_REPOSITORY_PROVIDER", "DIRIGIBLE_REPOSITORY_DATABASE_DATASOURCE_NAME", "DIRIGIBLE_MASTER_REPOSITORY_PROVIDER", "DIRIGIBLE_MASTER_REPOSITORY_ZIP_LOCATION", "DIRIGIBLE_MASTER_REPOSITORY_JAR_PATH", "DIRIGIBLE_REPOSITORY_SEARCH_ROOT_FOLDER", "DIRIGIBLE_REPOSITORY_SEARCH_ROOT_FOLDER_IS_ABSOLUTE", "DIRIGIBLE_REPOSITORY_SEARCH_INDEX_LOCATION", "DIRIGIBLE_REPOSITORY_VERSIONING_ENABLED", "DIRIGIBLE_DATABASE_PROVIDER", "DIRIGIBLE_DATABASE_DEFAULT_SET_AUTO_COMMIT", "DIRIGIBLE_DATABASE_DEFAULT_MAX_CONNECTIONS_COUNT", "DIRIGIBLE_DATABASE_DEFAULT_WAIT_TIMEOUT", "DIRIGIBLE_DATABASE_DEFAULT_WAIT_COUNT", "DIRIGIBLE_DATABASE_CUSTOM_DATASOURCES", "DIRIGIBLE_DATABASE_DATASOURCE_NAME_DEFAULT", "DIRIGIBLE_DATABASE_DERBY_ROOT_FOLDER_DEFAULT", "DIRIGIBLE_DATABASE_H2_ROOT_FOLDER_DEFAULT", "DIRIGIBLE_DATABASE_H2_DRIVER", "DIRIGIBLE_DATABASE_H2_URL", "DIRIGIBLE_DATABASE_H2_USERNAME", "DIRIGIBLE_DATABASE_H2_PASSWORD", "DIRIGIBLE_DATABASE_TRANSFER_BATCH_SIZE", "DIRIGIBLE_PERSISTENCE_CREATE_TABLE_ON_USE", "DIRIGIBLE_MONGODB_CLIENT_URI", "DIRIGIBLE_MONGODB_DATABASE_DEFAULT", "DIRIGIBLE_SCHEDULER_MEMORY_STORE", "DIRIGIBLE_SCHEDULER_DATASOURCE_TYPE", "DIRIGIBLE_SCHEDULER_DATASOURCE_NAME", "DIRIGIBLE_SCHEDULER_DATABASE_DELEGATE", "DIRIGIBLE_SCHEDULER_LOGS_RETANTION_PERIOD", "DIRIGIBLE_SCHEDULER_EMAIL_SENDER", "DIRIGIBLE_SCHEDULER_EMAIL_RECIPIENTS", "DIRIGIBLE_SCHEDULER_EMAIL_SUBJECT_ERROR", "DIRIGIBLE_SCHEDULER_EMAIL_SUBJECT_NORMAL", "DIRIGIBLE_SCHEDULER_EMAIL_TEMPLATE_ERROR", "DIRIGIBLE_SCHEDULER_EMAIL_TEMPLATE_NORMAL", "DIRIGIBLE_SCHEDULER_EMAIL_URL_SCHEME", "DIRIGIBLE_SCHEDULER_EMAIL_URL_HOST", "DIRIGIBLE_SCHEDULER_EMAIL_URL_PORT", "DIRIGIBLE_SYNCHRONIZER_IGNORE_DEPENDENCIES", "DIRIGIBLE_SYNCHRONIZER_EXCLUDE_PATHS", "DIRIGIBLE_HOME_URL", "DIRIGIBLE_JOB_EXPRESSION_BPM", "DIRIGIBLE_JOB_EXPRESSION_DATA_STRUCTURES", "DIRIGIBLE_JOB_EXPRESSION_EXTENSIONS", "DIRIGIBLE_JOB_EXPRESSION_JOBS", "DIRIGIBLE_JOB_EXPRESSION_MESSAGING", "DIRIGIBLE_JOB_EXPRESSION_MIGRATIONS", "DIRIGIBLE_JOB_EXPRESSION_ODATA", "DIRIGIBLE_JOB_EXPRESSION_PUBLISHER", "DIRIGIBLE_JOB_EXPRESSION_SECURITY", "DIRIGIBLE_JOB_EXPRESSION_REGISTRY", "DIRIGIBLE_JOB_DEFAULT_TIMEOUT", "DIRIGIBLE_CMS_PROVIDER", "DIRIGIBLE_CMS_ROLES_ENABLED", "DIRIGIBLE_CMS_INTERNAL_ROOT_FOLDER", "DIRIGIBLE_CMS_INTERNAL_ROOT_FOLDER_IS_ABSOLUTE", "DIRIGIBLE_CMS_INTERNAL_VERSIONING_ENABLED", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_JNDI_NAME", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_NAME", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_KEY", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_DESTINATION", "DIRIGIBLE_CONNECTIVITY_CONFIGURATION_JNDI_NAME", "DIRIGIBLE_CMS_DATABASE_DATASOURCE_TYPE", "DIRIGIBLE_CMS_DATABASE_DATASOURCE_NAME", "DIRIGIBLE_BPM_PROVIDER", "DIRIGIBLE_FLOWABLE_DATABASE_DRIVER", "DIRIGIBLE_FLOWABLE_DATABASE_URL", "DIRIGIBLE_FLOWABLE_DATABASE_USER", "DIRIGIBLE_FLOWABLE_DATABASE_PASSWORD", "DIRIGIBLE_FLOWABLE_DATABASE_DATASOURCE_NAME", "DIRIGIBLE_FLOWABLE_DATABASE_SCHEMA_UPDATE", "DIRIGIBLE_FLOWABLE_USE_SYSTEM_DATASOURCE", "DIRIGIBLE_MESSAGING_USE_DEFAULT_DATABASE", "DIRIGIBLE_KAFKA_BOOTSTRAP_SERVER", "DIRIGIBLE_KAFKA_ACKS", "DIRIGIBLE_KAFKA_KEY_SERIALIZER", "DIRIGIBLE_KAFKA_VALUE_SERIALIZER", "DIRIGIBLE_KAFKA_AUTOCOMMIT_ENABLED", "DIRIGIBLE_KAFKA_AUTOCOMMIT_INTERVAL", "DIRIGIBLE_JAVASCRIPT_ENGINE_TYPE_DEFAULT", "DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT", "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_HOST_ACCESS", "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_THREAD", "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_PROCESS", "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_IO", "DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_NASHORN", "DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA", "DIRIGIBLE_OPERATIONS_LOGS_ROOT_FOLDER_DEFAULT", "DIRIGIBLE_THEME_DEFAULT", "DIRIGIBLE_GENERATE_PRETTY_NAMES", "DIRIGIBLE_OAUTH_ENABLED", "DIRIGIBLE_OAUTH_AUTHORIZE_UR", "DIRIGIBLE_OAUTH_TOKEN_URL", "DIRIGIBLE_OAUTH_CLIENT_ID", "DIRIGIBLE_OAUTH_CLIENT_SECRET", "DIRIGIBLE_OAUTH_VERIFICATION_KEY", "DIRIGIBLE_OAUTH_APPLICATION_NAME", "DIRIGIBLE_OAUTH_APPLICATION_HOST", "DIRIGIBLE_OAUTH_ISSUER", "DIRIGIBLE_OAUTH_AUTHORIZE_URL", "DIRIGIBLE_OAUTH_TOKEN_REQUEST_METHOD", "DIRIGIBLE_OAUTH_VERIFICATION_KEY", "DIRIGIBLE_OAUTH_VERIFICATION_KEY_EXPONENT", "DIRIGIBLE_OAUTH_CHECK_ISSUER_ENABLED", "DIRIGIBLE_OAUTH_CHECK_AUDIENCE_ENABLED", "DIRIGIBLE_OAUTH_APPLICATION_NAME", "DIRIGIBLE_PRODUCT_NAME", "DIRIGIBLE_PRODUCT_VERSION", "DIRIGIBLE_PRODUCT_REPOSITORY", "DIRIGIBLE_PRODUCT_COMMIT_ID", "DIRIGIBLE_PRODUCT_TYPE", "DIRIGIBLE_INSTANCE_NAME", "DIRIGIBLE_SPARK_CLIENT_URI", "DIRIGIBLE_EXEC_COMMAND_LOGGING_ENABLED", "DIRIGIBLE_TERMINAL_ENABLED", "DIRIGIBLE_MAIL_CONFIG_PROVIDER", "DIRIGIBLE_MAIL_USERNAME", "DIRIGIBLE_MAIL_PASSWORD", "DIRIGIBLE_MAIL_TRANSPORT_PROTOCOL", "DIRIGIBLE_MAIL_SMTPS_HOST", "DIRIGIBLE_MAIL_SMTPS_PORT", "DIRIGIBLE_MAIL_SMTPS_AUTH", "DIRIGIBLE_MAIL_SMTP_HOST", "DIRIGIBLE_MAIL_SMTP_PORT", "DIRIGIBLE_MAIL_SMTP_AUTH", "DIRIGIBLE_KEYCLOAK_AUTH_SERVER_URL", "DIRIGIBLE_KEYCLOAK_CLIENT_ID", "DIRIGIBLE_CSV_DATA_MAX_COMPARE_SIZE", "DIRIGIBLE_CSV_DATA_BATCH_SIZE", "DIRIGIBLE_DESTINATION_CLIENT_ID", "DIRIGIBLE_DESTINATION_CLIENT_SECRET", "DIRIGIBLE_DESTINATION_URL", "DIRIGIBLE_DESTINATION_URI", "DIRIGIBLE_BASIC_ENABLED", "DIRIGIBLE_FTP_USERNAME", "DIRIGIBLE_FTP_PASSWORD", "DIRIGIBLE_FTP_PORT", "DIRIGIBLE_SFTP_USERNAME", "DIRIGIBLE_SFTP_PASSWORD", "DIRIGIBLE_SFTP_PORT", "SERVER_MAXHTTPHEADERSIZE", "DIRIGIBLE_PUBLISH_DISABLED", "AWS_DEFAULT_REGION", "AWS_ACCESS_KEY_ID", "AWS_SECRET_ACCESS_KEY", "DIRIGIBLE_S3_PROVIDER", "DIRIGIBLE_S3_BUCKET", "DIRIGIBLE_DATABASE_SYSTEM_DRIVER", "DIRIGIBLE_DATABASE_SYSTEM_URL", "DIRIGIBLE_DATABASE_SYSTEM_USERNAME", "DIRIGIBLE_DATABASE_SYSTEM_PASSWORD", "SNOWFLAKE_DEFAULT_TABLE_TYPE", "DIRIGIBLE_PROJECT_TYPESCRIPT");
        Set configs = Arrays.stream(DirigibleConfig.values()).map(DirigibleConfig::getKey).collect(Collectors.toSet());
        HashSet<String> allCfgParams = new HashSet<String>(staticParams);
        allCfgParams.addAll(configs);
        return allCfgParams.toArray(new String[0]);
    }

    private static void loadDeploymentConfig(String path) {
        Configuration.load(path, ConfigType.DEPLOYMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void load(String path, ConfigType type) {
        block16: {
            try {
                custom = new Properties();
                in = Configuration.class.getResourceAsStream(path);
                if (in != null) {
                    try {
                        custom.load(in);
                        switch (type.ordinal()) {
                            case 0: {
                                Configuration.addConfigProperties(custom, Configuration.RUNTIME_VARIABLES);
                                ** break;
lbl11:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                Configuration.addConfigProperties(custom, Configuration.ENVIRONMENT_VARIABLES);
                                ** break;
lbl15:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                Configuration.addConfigProperties(custom, Configuration.DEPLOYMENT_VARIABLES);
                                ** break;
lbl19:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                Configuration.addConfigProperties(custom, Configuration.MODULE_VARIABLES);
                                ** break;
lbl23:
                                // 1 sources

                                break;
                            }
                            ** default:
lbl25:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        in.close();
                    }
                    if (Configuration.logger.isDebugEnabled()) {
                        Configuration.logger.debug("Configuration loaded: " + path);
                    }
                    break block16;
                }
                if (!path.equals("/dirigible.properties")) {
                    throw new IOException(MessageFormat.format("Configuration file {0} does not exist", new Object[]{path}));
                }
                if (Configuration.logger.isDebugEnabled()) {
                    Configuration.logger.debug(MessageFormat.format("Configuration file {0} does not exist", new Object[]{path}));
                }
            }
            catch (IOException e) {
                if (!Configuration.logger.isErrorEnabled()) break block16;
                Configuration.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void addConfigProperties(Properties properties, Map<String, String> map) {
        for (String property : properties.stringPropertyNames()) {
            map.put(property, properties.getProperty(property));
        }
    }

    public static void loadModuleConfig(String path) {
        Configuration.load(path, ConfigType.MODULE);
    }

    public static int getAsInt(String key) {
        return Configuration.getAsInt(key, 0);
    }

    public static int getAsInt(String key, int defaultValue) {
        String stringValue = Configuration.get(key, "" + defaultValue);
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException nfe) {
            logger.error("The configuration key: {} points to non integer value: {}", new Object[]{key, stringValue, nfe});
            return defaultValue;
        }
    }

    public static String get(String key, String defaultValue) {
        String value = null;
        if (RUNTIME_VARIABLES.containsKey(key)) {
            value = RUNTIME_VARIABLES.get(key);
        } else if (ENVIRONMENT_VARIABLES.containsKey(key)) {
            value = ENVIRONMENT_VARIABLES.get(key);
        } else if (DEPLOYMENT_VARIABLES.containsKey(key)) {
            value = DEPLOYMENT_VARIABLES.get(key);
        } else if (MODULE_VARIABLES.containsKey(key)) {
            value = MODULE_VARIABLES.get(key);
        }
        return value != null ? value : defaultValue;
    }

    public static void setIfNull(String key, String value) {
        if (Configuration.get(key) == null) {
            Configuration.set(key, value);
        }
    }

    public static String get(String key) {
        return Configuration.get(key, null);
    }

    public static void set(String key, String value) {
        RUNTIME_VARIABLES.put(key, value);
    }

    public static void remove(String key) {
        RUNTIME_VARIABLES.remove(key);
    }

    public static String[] getKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(RUNTIME_VARIABLES.keySet());
        keys.addAll(ENVIRONMENT_VARIABLES.keySet());
        keys.addAll(DEPLOYMENT_VARIABLES.keySet());
        keys.addAll(MODULE_VARIABLES.keySet());
        return keys.toArray(new String[0]);
    }

    public static void update() {
        Configuration.loadEnvironmentConfig();
    }

    private static void loadEnvironmentConfig() {
        Configuration.addConfigProperties(System.getenv(), ConfigType.ENVIRONMENT);
        Configuration.addConfigProperties(System.getProperties(), ConfigType.ENVIRONMENT);
    }

    private static void addConfigProperties(Map<String, String> properties, ConfigType type) {
        switch (type.ordinal()) {
            case 0: {
                RUNTIME_VARIABLES.putAll(properties);
                break;
            }
            case 1: {
                ENVIRONMENT_VARIABLES.putAll(properties);
                break;
            }
            case 2: {
                DEPLOYMENT_VARIABLES.putAll(properties);
                break;
            }
            case 3: {
                MODULE_VARIABLES.putAll(properties);
                break;
            }
        }
    }

    private static void addConfigProperties(Properties properties, ConfigType type) {
        switch (type.ordinal()) {
            case 0: {
                Configuration.addConfigProperties(properties, RUNTIME_VARIABLES);
                break;
            }
            case 1: {
                Configuration.addConfigProperties(properties, ENVIRONMENT_VARIABLES);
                break;
            }
            case 2: {
                Configuration.addConfigProperties(properties, DEPLOYMENT_VARIABLES);
                break;
            }
            case 3: {
                Configuration.addConfigProperties(properties, MODULE_VARIABLES);
                break;
            }
        }
    }

    public static boolean isAnonymousModeEnabled() {
        try {
            Class.forName("org.eclipse.dirigible.runtime.anonymous.AnonymousAccess");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return !Configuration.isProtectedModeEnabled();
    }

    private static boolean isProtectedModeEnabled() {
        return Configuration.isKeycloakModeEnabled() || Configuration.isOAuthAuthenticationEnabled() || Configuration.isJwtModeEnabled();
    }

    public static boolean isAnonymousUserEnabled() {
        try {
            Class.forName("org.eclipse.dirigible.anonymous.AnonymousUser");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return !Configuration.isProtectedModeEnabled();
    }

    public static boolean isOAuthAuthenticationEnabled() {
        return Configuration.isActiveSpringProfile("oauth");
    }

    public static boolean isKeycloakModeEnabled() {
        return Configuration.isActiveSpringProfile("keycloak");
    }

    private static boolean isActiveSpringProfile(String profile) {
        return Configuration.get("spring.profiles.active", "").contains(profile) || Configuration.get("spring_profiles_active", "").contains(profile);
    }

    public static boolean isJwtModeEnabled() {
        boolean enabled = false;
        if (Configuration.isOAuthAuthenticationEnabled()) {
            try {
                Class.forName("org.eclipse.dirigible.jwt.JwtAccess");
                enabled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return enabled;
    }

    public static boolean isProductiveIFrameEnabled() {
        return Boolean.parseBoolean(Configuration.get("DIRIGIBLE_PRODUCTIVE_IFRAME_ENABLED", Boolean.TRUE.toString()));
    }

    public static boolean isTerminalEnabled() {
        return Boolean.parseBoolean(Configuration.get("DIRIGIBLE_TERMINAL_ENABLED", Boolean.TRUE.toString()));
    }

    public static void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public static Map<String, String> getRuntimeVariables() {
        return new HashMap<String, String>(RUNTIME_VARIABLES);
    }

    public static Map<String, String> getEnvironmentVariables() {
        return new HashMap<String, String>(ENVIRONMENT_VARIABLES);
    }

    public static Map<String, String> getDeploymentVariables() {
        return new HashMap<String, String>(DEPLOYMENT_VARIABLES);
    }

    public static Map<String, String> getModuleVariables() {
        return new HashMap<String, String>(MODULE_VARIABLES);
    }

    public static boolean isOSWindows() {
        return Configuration.getOS().contains("win");
    }

    public static String getOS() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isOSMac() {
        return Configuration.getOS().contains("mac");
    }

    public static boolean isOSUNIX() {
        return Configuration.getOS().contains("nix") || Configuration.getOS().contains("nux") || Configuration.getOS().indexOf("aix") > 0;
    }

    public static boolean isOSSolaris() {
        return Configuration.getOS().contains("sunos");
    }

    public static String[] getConfigurationParameters() {
        return (String[])CONFIGURATION_PARAMETERS.clone();
    }

    public static void configureObject(Object o) {
        if (o == null) {
            return;
        }
        try {
            for (Field field : FieldUtils.getAllFields(o.getClass())) {
                Object v = FieldUtils.readField((Field)field, (Object)o, (boolean)true);
                if (v == null || !(v instanceof String)) continue;
                String s = (String)v;
                if (s.startsWith("${") && s.endsWith("}")) {
                    String k;
                    if (s.indexOf("}.{") > 0) {
                        k = s.substring(2, s.indexOf("}.{"));
                        String d = s.substring(s.indexOf("}.{") + 3, s.length() - 1);
                        FieldUtils.writeField((Field)field, (Object)o, (Object)Configuration.get(k, d), (boolean)true);
                        continue;
                    }
                    k = s.substring(2, s.length() - 1);
                    FieldUtils.writeField((Field)field, (Object)o, (Object)Configuration.get(k), (boolean)true);
                    continue;
                }
                Matcher matcher = MULTIVARIABLE_PATTERN.matcher(s);
                if (!matcher.find()) continue;
                String finalValue = s;
                do {
                    String placeholder = matcher.group(0);
                    String configName = matcher.group(1);
                    String replacement = Configuration.get(configName);
                    if (null == replacement) {
                        logger.warn("Missing configuration with name: [{}]. The value will not be replaced for field [{}] with value [{}]", new Object[]{configName, field.getName(), v});
                        continue;
                    }
                    finalValue = finalValue.replaceAll(Pattern.quote(placeholder), replacement);
                } while (matcher.find());
                FieldUtils.writeField((Field)field, (Object)o, (Object)finalValue, (boolean)true);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        Configuration.loadDeploymentConfig(CONFIG_FILE_PATH_DIRIGIBLE_PROPERTIES);
        Configuration.loadEnvironmentConfig();
        LOADED = true;
    }

    private static enum ConfigType {
        RUNTIME,
        ENVIRONMENT,
        DEPLOYMENT,
        MODULE;

    }
}

