/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.config;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DirigibleConfig {
    SNOWFLAKE_DATA_SOURCE_LIFESPAN_SECONDS("DIRIGIBLE_SNOWFLAKE_DATA_SOURCE_LIFESPAN_SECONDS", "540"),
    LEAKED_CONNECTIONS_MAX_IN_USE_SECONDS("DIRIGIBLE_LEAKED_CONNECTIONS_MAX_IN_USE_SECONDS", "180"),
    LEAKED_CONNECTIONS_CHECK_INTERVAL_SECONDS("DIRIGIBLE_LEAKED_CONNECTIONS_CHECK_INTERVAL_SECONDS", "30"),
    TENANTS_PROVISIONING_FREQUENCY_SECONDS("DIRIGIBLE_TENANTS_PROVISIONING_FREQUENCY_SECONDS", "900"),
    CMS_INTERNAL_ROOT_FOLDER("DIRIGIBLE_CMS_INTERNAL_ROOT_FOLDER", "target/dirigible/cms"),
    DEFAULT_DATA_SOURCE_NAME("DIRIGIBLE_DATABASE_DATASOURCE_NAME_DEFAULT", "DefaultDB"),
    SYSTEM_DATA_SOURCE_NAME("DIRIGIBLE_DATABASE_DATASOURCE_NAME_SYSTEM", "SystemDB"),
    SYNCHRONIZER_FREQUENCY("DIRIGIBLE_SYNCHRONIZER_FREQUENCY", "10"),
    TRIAL_ENABLED("DIRIGIBLE_TRIAL_ENABLED", Boolean.FALSE.toString()),
    REPOSITORY_LOCAL_ROOT_FOLDER("DIRIGIBLE_REPOSITORY_LOCAL_ROOT_FOLDER", "target"),
    MULTI_TENANT_MODE_ENABLED("DIRIGIBLE_MULTI_TENANT_MODE", Boolean.FALSE.toString()),
    TENANT_SUBDOMAIN_REGEX("DIRIGIBLE_TENANT_SUBDOMAIN_REGEX", "^([^\\.]+)\\..+$"),
    BASIC_ADMIN_USERNAME("DIRIGIBLE_BASIC_USERNAME", DirigibleConfig.toBase64("admin")),
    BASIC_ADMIN_PASS("DIRIGIBLE_BASIC_PASSWORD", DirigibleConfig.toBase64("admin"));

    private static final Logger LOGGER;
    private final String key;
    private final String defaultValue;

    private DirigibleConfig(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFromBase64Value() {
        String val = this.getStringValue();
        return DirigibleConfig.fromBase64(val);
    }

    public String getStringValue() {
        return Configuration.get(this.key, this.defaultValue);
    }

    private static String fromBase64(String string) {
        return new String(Base64.getDecoder().decode(string), StandardCharsets.UTF_8);
    }

    private static String toBase64(String string) {
        return Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
    }

    public String getKey() {
        return this.key;
    }

    public boolean getBooleanValue() {
        String configValue = this.getStringValue();
        return Boolean.valueOf(configValue);
    }

    public int getIntValue() {
        String stringValue = this.getStringValue();
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Configuration with key [{}] has invalid non integer value: {}. Returning the defalt value [{}]", new Object[]{this.key, stringValue, this.defaultValue, ex});
            return Integer.parseInt(this.defaultValue);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(DirigibleConfig.class);
    }
}

