/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.config.health;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.commons.config.timeout.TimeLimited;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthStatus {
    private static final Logger logger = LoggerFactory.getLogger(HealthStatus.class);
    private static final HealthStatus INSTANCE = new HealthStatus();
    private long started = System.currentTimeMillis();
    private Status status = Status.NotReady;
    private Status currentStatus = Status.NotReady;
    private Jobs jobs = new Jobs();

    public static HealthStatus getInstance() {
        if (!HealthStatus.INSTANCE.status.equals((Object)Status.Ready) && System.currentTimeMillis() - HealthStatus.INSTANCE.started > (long)TimeLimited.getTimeoutInMillis()) {
            HealthStatus.INSTANCE.status = Status.Ready;
            logger.warn("Health status: one or more synchronizers still in progress...");
        }
        return INSTANCE;
    }

    private static void setCurrentStatus() {
        HealthStatus healthStatus = HealthStatus.getInstance();
        healthStatus.currentStatus = Status.Ready;
        for (Jobs.JobStatus next : healthStatus.getJobs().getJobsStatuses()) {
            if (next.equals((Object)Jobs.JobStatus.Running)) {
                healthStatus.currentStatus = Status.Running;
                break;
            }
            if (!next.equals((Object)Jobs.JobStatus.Failed)) continue;
            healthStatus.currentStatus = Status.NotReady;
            break;
        }
        if (!healthStatus.status.equals((Object)Status.Ready) && healthStatus.currentStatus.equals((Object)Status.Ready)) {
            healthStatus.status = Status.Ready;
        }
    }

    private HealthStatus() {
    }

    public Status getStatus() {
        return this.status;
    }

    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    public Jobs getJobs() {
        return this.jobs;
    }

    public static enum Status {
        Ready,
        NotReady,
        Running;

    }

    public static class Jobs {
        private Map<String, JobStatus> statuses = new HashMap<String, JobStatus>();

        public Map<String, JobStatus> getStatuses() {
            return this.statuses;
        }

        public void setStatus(String name, JobStatus status) {
            this.statuses.put(name, status);
            HealthStatus.setCurrentStatus();
        }

        private Collection<JobStatus> getJobsStatuses() {
            return this.statuses.values();
        }

        public static enum JobStatus {
            Running,
            Succeeded,
            Failed;

        }
    }
}

