/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.config.timeout;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLimited {
    private static final Logger logger = LoggerFactory.getLogger(TimeLimited.class);
    private static final String DIRIGIBLE_JOB_DEFAULT_TIMEOUT = "DIRIGIBLE_JOB_DEFAULT_TIMEOUT";
    private static final String DEFAULT_TIMEOUT = "3";

    public static synchronized void runWithTimeout(final Runnable runnable, long timeout, TimeUnit timeUnit) throws Exception {
        TimeLimited.runWithTimeout(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                runnable.run();
                return null;
            }
        }, timeout, timeUnit);
    }

    private static <T> T runWithTimeout(Callable<T> callable, long timeout, TimeUnit timeUnit) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<T> future = executor.submit(callable);
        executor.shutdown();
        try {
            return future.get(timeout, timeUnit);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new IllegalStateException(t);
        }
    }

    public static final int getTimeout() {
        String defaultTimeout = Configuration.get(DIRIGIBLE_JOB_DEFAULT_TIMEOUT, DEFAULT_TIMEOUT);
        try {
            return Integer.parseInt(defaultTimeout);
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Integer.parseInt(DEFAULT_TIMEOUT);
        }
    }

    public static final int getTimeoutInMillis() {
        return TimeLimited.getTimeout() * 1000 * 60;
    }
}

