/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.config;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static final Map<String, String> RUNTIME_VARIABLES = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> ENVIRONMENT_VARIABLES = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> DEPLOYMENT_VARIABLES = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> MODULE_VARIABLES = Collections.synchronizedMap(new HashMap());
    private static final String CONFIG_FILE_PATH_DIRIGIBLE_PROPERTIES = "/dirigible.properties";
    private static final String ERROR_MESSAGE_CONFIGURATION_DOES_NOT_EXIST = "Configuration file {0} does not exist";
    public static boolean LOADED = false;
    private static final String[] CONFIGURATION_PARAMETERS;

    private static void loadEnvironmentConfig() {
        Configuration.addConfigProperties(System.getenv(), ConfigType.ENVIRONMENT);
        Configuration.addConfigProperties(System.getProperties(), ConfigType.ENVIRONMENT);
    }

    private static void loadDeploymentConfig(String path) {
        Configuration.load(path, ConfigType.DEPLOYMENT);
    }

    public static void loadModuleConfig(String path) {
        Configuration.load(path, ConfigType.MODULE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void load(String path, ConfigType type) {
        block16: {
            try {
                custom = new Properties();
                in = Configuration.class.getResourceAsStream(path);
                if (in != null) {
                    try {
                        custom.load(in);
                        switch (1.$SwitchMap$org$eclipse$dirigible$commons$config$Configuration$ConfigType[type.ordinal()]) {
                            case 1: {
                                Configuration.addConfigProperties(custom, Configuration.RUNTIME_VARIABLES);
                                ** break;
lbl11:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                Configuration.addConfigProperties(custom, Configuration.ENVIRONMENT_VARIABLES);
                                ** break;
lbl15:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                Configuration.addConfigProperties(custom, Configuration.DEPLOYMENT_VARIABLES);
                                ** break;
lbl19:
                                // 1 sources

                                break;
                            }
                            case 4: {
                                Configuration.addConfigProperties(custom, Configuration.MODULE_VARIABLES);
                                ** break;
lbl23:
                                // 1 sources

                                break;
                            }
                            ** default:
lbl25:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        in.close();
                    }
                    if (Configuration.logger.isDebugEnabled()) {
                        Configuration.logger.debug("Configuration loaded: " + path);
                    }
                    break block16;
                }
                if (!path.equals("/dirigible.properties")) {
                    throw new IOException(MessageFormat.format("Configuration file {0} does not exist", new Object[]{path}));
                }
                if (Configuration.logger.isDebugEnabled()) {
                    Configuration.logger.debug(MessageFormat.format("Configuration file {0} does not exist", new Object[]{path}));
                }
            }
            catch (IOException e) {
                if (!Configuration.logger.isErrorEnabled()) break block16;
                Configuration.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void addConfigProperties(Map<String, String> properties, ConfigType type) {
        switch (type) {
            case RUNTIME: {
                RUNTIME_VARIABLES.putAll(properties);
                break;
            }
            case ENVIRONMENT: {
                ENVIRONMENT_VARIABLES.putAll(properties);
                break;
            }
            case DEPLOYMENT: {
                DEPLOYMENT_VARIABLES.putAll(properties);
                break;
            }
            case MODULE: {
                MODULE_VARIABLES.putAll(properties);
                break;
            }
        }
    }

    private static void addConfigProperties(Properties properties, ConfigType type) {
        switch (type) {
            case RUNTIME: {
                Configuration.addConfigProperties(properties, RUNTIME_VARIABLES);
                break;
            }
            case ENVIRONMENT: {
                Configuration.addConfigProperties(properties, ENVIRONMENT_VARIABLES);
                break;
            }
            case DEPLOYMENT: {
                Configuration.addConfigProperties(properties, DEPLOYMENT_VARIABLES);
                break;
            }
            case MODULE: {
                Configuration.addConfigProperties(properties, MODULE_VARIABLES);
                break;
            }
        }
    }

    private static void addConfigProperties(Properties properties, Map<String, String> map) {
        for (String property : properties.stringPropertyNames()) {
            map.put(property, properties.getProperty(property));
        }
    }

    public static String get(String key) {
        return Configuration.get(key, null);
    }

    public static String get(String key, String defaultValue) {
        String value = null;
        if (RUNTIME_VARIABLES.containsKey(key)) {
            value = RUNTIME_VARIABLES.get(key);
        } else if (ENVIRONMENT_VARIABLES.containsKey(key)) {
            value = ENVIRONMENT_VARIABLES.get(key);
        } else if (DEPLOYMENT_VARIABLES.containsKey(key)) {
            value = DEPLOYMENT_VARIABLES.get(key);
        } else if (MODULE_VARIABLES.containsKey(key)) {
            value = MODULE_VARIABLES.get(key);
        }
        return value != null ? value : defaultValue;
    }

    public static void set(String key, String value) {
        RUNTIME_VARIABLES.put(key, value);
    }

    public static void setIfNull(String key, String value) {
        if (Configuration.get(key) == null) {
            Configuration.set(key, value);
        }
    }

    public static void remove(String key) {
        RUNTIME_VARIABLES.remove(key);
    }

    public static String[] getKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(RUNTIME_VARIABLES.keySet());
        keys.addAll(ENVIRONMENT_VARIABLES.keySet());
        keys.addAll(DEPLOYMENT_VARIABLES.keySet());
        keys.addAll(MODULE_VARIABLES.keySet());
        return keys.toArray(new String[0]);
    }

    public static void update() {
        Configuration.loadEnvironmentConfig();
    }

    public static boolean isAnonymousModeEnabled() {
        try {
            Class.forName("org.eclipse.dirigible.runtime.anonymous.AnonymousAccess");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return !Configuration.isProtectedModeEnabled();
    }

    private static boolean isProtectedModeEnabled() {
        return Configuration.isKeycloakModeEnabled() || Configuration.isOAuthAuthenticationEnabled() || Configuration.isJwtModeEnabled();
    }

    public static boolean isAnonymousUserEnabled() {
        try {
            Class.forName("org.eclipse.dirigible.anonymous.AnonymousUser");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return !Configuration.isProtectedModeEnabled();
    }

    public static boolean isOAuthAuthenticationEnabled() {
        return Boolean.parseBoolean(Configuration.get("DIRIGIBLE_OAUTH_ENABLED", Boolean.FALSE.toString()));
    }

    public static boolean isKeycloakModeEnabled() {
        return Boolean.parseBoolean(Configuration.get("DIRIGIBLE_KEYCLOAK_ENABLED", Boolean.FALSE.toString()));
    }

    public static boolean isJwtModeEnabled() {
        boolean enabled = false;
        if (Configuration.isOAuthAuthenticationEnabled()) {
            try {
                Class.forName("org.eclipse.dirigible.jwt.JwtAccess");
                enabled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return enabled;
    }

    public static boolean isProductiveIFrameEnabled() {
        return Boolean.parseBoolean(Configuration.get("DIRIGIBLE_PRODUCTIVE_IFRAME_ENABLED", Boolean.TRUE.toString()));
    }

    public static boolean isTerminalEnabled() {
        return Boolean.parseBoolean(Configuration.get("DIRIGIBLE_TERMINAL_ENABLED", Boolean.TRUE.toString()));
    }

    public static void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public static Map<String, String> getRuntimeVariables() {
        return new HashMap<String, String>(RUNTIME_VARIABLES);
    }

    public static Map<String, String> getEnvironmentVariables() {
        return new HashMap<String, String>(ENVIRONMENT_VARIABLES);
    }

    public static Map<String, String> getDeploymentVariables() {
        return new HashMap<String, String>(DEPLOYMENT_VARIABLES);
    }

    public static Map<String, String> getModuleVariables() {
        return new HashMap<String, String>(MODULE_VARIABLES);
    }

    public static String getOS() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isOSWindows() {
        return Configuration.getOS().indexOf("win") >= 0;
    }

    public static boolean isOSMac() {
        return Configuration.getOS().indexOf("mac") >= 0;
    }

    public static boolean isOSUNIX() {
        return Configuration.getOS().indexOf("nix") >= 0 || Configuration.getOS().indexOf("nux") >= 0 || Configuration.getOS().indexOf("aix") > 0;
    }

    public static boolean isOSSolaris() {
        return Configuration.getOS().indexOf("sunos") >= 0;
    }

    public static String[] getConfigurationParameters() {
        return (String[])CONFIGURATION_PARAMETERS.clone();
    }

    public static void configureObject(Object o) {
        if (o == null) {
            return;
        }
        try {
            for (Field field : FieldUtils.getAllFields(o.getClass())) {
                String k;
                String s;
                Object v = FieldUtils.readField((Field)field, (Object)o, (boolean)true);
                if (v == null || !(v instanceof String) || !(s = (String)v).startsWith("${") || !s.endsWith("}")) continue;
                if (s.indexOf("}.{") > 0) {
                    k = s.substring(2, s.indexOf("}.{"));
                    String d = s.substring(s.indexOf("}.{") + 3, s.length() - 1);
                    FieldUtils.writeField((Field)field, (Object)o, (Object)Configuration.get(k, d), (boolean)true);
                    continue;
                }
                k = s.substring(2, s.length() - 1);
                FieldUtils.writeField((Field)field, (Object)o, (Object)Configuration.get(k), (boolean)true);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        Configuration.loadDeploymentConfig(CONFIG_FILE_PATH_DIRIGIBLE_PROPERTIES);
        Configuration.loadEnvironmentConfig();
        LOADED = true;
        CONFIGURATION_PARAMETERS = new String[]{"DIRIGIBLE_ANONYMOUS_USER_NAME_PROPERTY_NAME", "DIRIGIBLE_BRANDING_NAME", "DIRIGIBLE_BRANDING_BRAND", "DIRIGIBLE_BRANDING_ICON", "DIRIGIBLE_BRANDING_WELCOME_PAGE_DEFAULT", "DIRIGIBLE_GIT_ROOT_FOLDER", "DIRIGIBLE_REGISTRY_EXTERNAL_FOLDER", "DIRIGIBLE_REGISTRY_IMPORT_WORKSPACE", "DIRIGIBLE_REPOSITORY_PROVIDER", "DIRIGIBLE_REPOSITORY_DATABASE_DATASOURCE_NAME", "DIRIGIBLE_REPOSITORY_LOCAL_ROOT_FOLDER", "DIRIGIBLE_REPOSITORY_LOCAL_ROOT_FOLDER_IS_ABSOLUTE", "DIRIGIBLE_MASTER_REPOSITORY_PROVIDER", "DIRIGIBLE_MASTER_REPOSITORY_ROOT_FOLDER", "DIRIGIBLE_MASTER_REPOSITORY_ZIP_LOCATION", "DIRIGIBLE_MASTER_REPOSITORY_JAR_PATH", "DIRIGIBLE_REPOSITORY_SEARCH_ROOT_FOLDER", "DIRIGIBLE_REPOSITORY_SEARCH_ROOT_FOLDER_IS_ABSOLUTE", "DIRIGIBLE_REPOSITORY_SEARCH_INDEX_LOCATION", "DIRIGIBLE_DATABASE_PROVIDER", "DIRIGIBLE_DATABASE_DEFAULT_SET_AUTO_COMMIT", "DIRIGIBLE_DATABASE_DEFAULT_MAX_CONNECTIONS_COUNT", "DIRIGIBLE_DATABASE_DEFAULT_WAIT_TIMEOUT", "DIRIGIBLE_DATABASE_DEFAULT_WAIT_COUNT", "DIRIGIBLE_DATABASE_CUSTOM_DATASOURCES", "DIRIGIBLE_DATABASE_DATASOURCE_NAME_DEFAULT", "DIRIGIBLE_DATABASE_NAMES_CASE_SENSITIVE", "DIRIGIBLE_DATABASE_DERBY_ROOT_FOLDER_DEFAULT", "DIRIGIBLE_DATABASE_H2_ROOT_FOLDER_DEFAULT", "DIRIGIBLE_DATABASE_H2_DRIVER", "DIRIGIBLE_DATABASE_H2_URL", "DIRIGIBLE_DATABASE_H2_USERNAME", "DIRIGIBLE_DATABASE_H2_PASSWORD", "DIRIGIBLE_DATABASE_TRANSFER_BATCH_SIZE", "DIRIGIBLE_PERSISTENCE_CREATE_TABLE_ON_USE", "DIRIGIBLE_MONGODB_CLIENT_URI", "DIRIGIBLE_MONGODB_DATABASE_DEFAULT", "DIRIGIBLE_SCHEDULER_MEMORY_STORE", "DIRIGIBLE_SCHEDULER_DATASOURCE_TYPE", "DIRIGIBLE_SCHEDULER_DATASOURCE_NAME", "DIRIGIBLE_SCHEDULER_DATABASE_DELEGATE", "DIRIGIBLE_SCHEDULER_LOGS_RETANTION_PERIOD", "DIRIGIBLE_SCHEDULER_EMAIL_SENDER", "DIRIGIBLE_SCHEDULER_EMAIL_RECIPIENTS", "DIRIGIBLE_SCHEDULER_EMAIL_SUBJECT_ERROR", "DIRIGIBLE_SCHEDULER_EMAIL_SUBJECT_NORMAL", "DIRIGIBLE_SCHEDULER_EMAIL_TEMPLATE_ERROR", "DIRIGIBLE_SCHEDULER_EMAIL_TEMPLATE_NORMAL", "DIRIGIBLE_SCHEDULER_EMAIL_URL_SCHEME", "DIRIGIBLE_SCHEDULER_EMAIL_URL_HOST", "DIRIGIBLE_SCHEDULER_EMAIL_URL_PORT", "DIRIGIBLE_SYNCHRONIZER_IGNORE_DEPENDENCIES", "DIRIGIBLE_SYNCHRONIZER_EXCLUDE_PATHS", "DIRIGIBLE_HOME_URL", "DIRIGIBLE_JOB_EXPRESSION_BPM", "DIRIGIBLE_JOB_EXPRESSION_DATA_STRUCTURES", "DIRIGIBLE_JOB_EXPRESSION_EXTENSIONS", "DIRIGIBLE_JOB_EXPRESSION_JOBS", "DIRIGIBLE_JOB_EXPRESSION_MESSAGING", "DIRIGIBLE_JOB_EXPRESSION_MIGRATIONS", "DIRIGIBLE_JOB_EXPRESSION_ODATA", "DIRIGIBLE_JOB_EXPRESSION_PUBLISHER", "DIRIGIBLE_JOB_EXPRESSION_SECURITY", "DIRIGIBLE_JOB_EXPRESSION_REGISTRY", "DIRIGIBLE_JOB_DEFAULT_TIMEOUT", "DIRIGIBLE_CMS_PROVIDER", "DIRIGIBLE_CMS_ROLES_ENABLED", "DIRIGIBLE_CMS_INTERNAL_ROOT_FOLDER", "DIRIGIBLE_CMS_INTERNAL_ROOT_FOLDER_IS_ABSOLUTE", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_JNDI_NAME", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_NAME", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_KEY", "DIRIGIBLE_CMS_MANAGED_CONFIGURATION_DESTINATION", "DIRIGIBLE_CONNECTIVITY_CONFIGURATION_JNDI_NAME", "DIRIGIBLE_CMS_DATABASE_DATASOURCE_TYPE", "DIRIGIBLE_CMS_DATABASE_DATASOURCE_NAME", "DIRIGIBLE_BPM_PROVIDER", "DIRIGIBLE_FLOWABLE_DATABASE_DRIVER", "DIRIGIBLE_FLOWABLE_DATABASE_URL", "DIRIGIBLE_FLOWABLE_DATABASE_USER", "DIRIGIBLE_FLOWABLE_DATABASE_PASSWORD", "DIRIGIBLE_FLOWABLE_DATABASE_DATASOURCE_NAME", "DIRIGIBLE_FLOWABLE_DATABASE_SCHEMA_UPDATE", "DIRIGIBLE_FLOWABLE_USE_SYSTEM_DATASOURCE", "DIRIGIBLE_MESSAGING_USE_DEFAULT_DATABASE", "DIRIGIBLE_KAFKA_BOOTSTRAP_SERVER", "DIRIGIBLE_KAFKA_ACKS", "DIRIGIBLE_KAFKA_KEY_SERIALIZER", "DIRIGIBLE_KAFKA_VALUE_SERIALIZER", "DIRIGIBLE_KAFKA_AUTOCOMMIT_ENABLED", "DIRIGIBLE_KAFKA_AUTOCOMMIT_INTERVAL", "DIRIGIBLE_JAVASCRIPT_ENGINE_TYPE_DEFAULT", "DIRIGIBLE_JAVASCRIPT_GRAALVM_DEBUGGER_PORT", "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_HOST_ACCESS", "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_THREAD", "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_CREATE_PROCESS", "DIRIGIBLE_JAVASCRIPT_GRAALVM_ALLOW_IO", "DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_NASHORN", "DIRIGIBLE_JAVASCRIPT_GRAALVM_COMPATIBILITY_MODE_MOZILLA", "DIRIGIBLE_OPERATIONS_LOGS_ROOT_FOLDER_DEFAULT", "DIRIGIBLE_THEME_DEFAULT", "DIRIGIBLE_GENERATE_PRETTY_NAMES", "DIRIGIBLE_OAUTH_ENABLED", "DIRIGIBLE_OAUTH_AUTHORIZE_UR", "DIRIGIBLE_OAUTH_TOKEN_URL", "DIRIGIBLE_OAUTH_CLIENT_ID", "DIRIGIBLE_OAUTH_CLIENT_SECRET", "DIRIGIBLE_OAUTH_VERIFICATION_KEY", "DIRIGIBLE_OAUTH_APPLICATION_NAME", "DIRIGIBLE_OAUTH_APPLICATION_HOST", "DIRIGIBLE_OAUTH_ISSUER", "DIRIGIBLE_PRODUCT_NAME", "DIRIGIBLE_PRODUCT_VERSION", "DIRIGIBLE_PRODUCT_REPOSITORY", "DIRIGIBLE_PRODUCT_COMMIT_ID", "DIRIGIBLE_PRODUCT_TYPE", "DIRIGIBLE_INSTANCE_NAME", "DIRIGIBLE_SPARK_CLIENT_URI", "DIRIGIBLE_EXEC_COMMAND_LOGGING_ENABLED", "DIRIGIBLE_TERMINAL_ENABLED", "DIRIGIBLE_MAIL_CONFIG_PROVIDER", "DIRIGIBLE_MAIL_USERNAME", "DIRIGIBLE_MAIL_PASSWORD", "DIRIGIBLE_MAIL_TRANSPORT_PROTOCOL", "DIRIGIBLE_MAIL_SMTPS_HOST", "DIRIGIBLE_MAIL_SMTPS_PORT", "DIRIGIBLE_MAIL_SMTPS_AUTH", "DIRIGIBLE_MAIL_SMTP_HOST", "DIRIGIBLE_MAIL_SMTP_PORT", "DIRIGIBLE_MAIL_SMTP_AUTH", "DIRIGIBLE_KEYCLOAK_ENABLED", "DIRIGIBLE_KEYCLOAK_REALM", "DIRIGIBLE_KEYCLOAK_AUTH_SERVER_URL", "DIRIGIBLE_KEYCLOAK_SSL_REQUIRED", "DIRIGIBLE_KEYCLOAK_CLIENT_ID", "DIRIGIBLE_KEYCLOAK_CONFIDENTIAL_PORT", "DIRIGIBLE_CSV_DATA_MAX_COMPARE_SIZE", "DIRIGIBLE_CSV_DATA_BATCH_SIZE", "DIRIGIBLE_DESTINATION_CLIENT_ID", "DIRIGIBLE_DESTINATION_CLIENT_SECRET", "DIRIGIBLE_DESTINATION_URL", "DIRIGIBLE_DESTINATION_URI"};
    }

    private static enum ConfigType {
        RUNTIME,
        ENVIRONMENT,
        DEPLOYMENT,
        MODULE;

    }
}

