/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StaticObjects {
    private static final Logger logger = LoggerFactory.getLogger(StaticObjects.class);
    public static final String DATASOURCE = "DATASOURCE";
    public static final String SYSTEM_DATASOURCE = "SYSTEM_DATASOURCE";
    public static final String DATABASE = "DATABASE";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String MASTER_REPOSITORY = "MASTER_REPOSITORY";
    public static final String DATABASE_REPOSITORY = "DATABASE_REPOSITORY";
    public static final String LOCAL_REPOSITORY = "LOCAL_REPOSITORY";
    public static final String CMS_PROVIDER = "CMS_PROVIDER";
    public static final String CMS_DATABASE_REPOSITORY = "CMS_DATABASE_REPOSITORY";
    public static final String JAVASCRIPT_ENGINE = "JAVASCRIPT_ENGINE";
    public static final String WEBSOCKET_HANDLER = "WEBSOCKET_HANDLER";
    public static final String BPM_PROVIDER = "BPM_PROVIDER";
    private static final Map<String, Object> OBJECTS = Collections.synchronizedMap(new HashMap());

    public static final Object get(String key) {
        Object object;
        if (logger.isTraceEnabled()) {
            logger.trace("Getting static object by key: " + key);
        }
        if ((object = OBJECTS.get(key)) == null) {
            String message = "Static object by key: " + key + " is null";
            if (logger.isErrorEnabled()) {
                logger.error(message);
            }
            new Exception(message).printStackTrace();
        }
        return object;
    }

    public static final void set(String key, Object object) {
        if (logger.isInfoEnabled()) {
            logger.info("Setting static object by key: " + key);
        }
        OBJECTS.put(key, object);
    }

    public static final boolean exists(String key) {
        Object object;
        if (logger.isTraceEnabled()) {
            logger.trace("Exists static object by key: " + key);
        }
        return (object = OBJECTS.get(key)) != null;
    }
}

