/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.dirigible.commons.api.context.ContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadContextFacade {
    private static final Logger logger = LoggerFactory.getLogger(ThreadContextFacade.class);
    private static final ThreadLocal<Map<Integer, Map<String, Object>>> STACKED_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<Map<Integer, Map<String, AutoCloseable>>> STACKED_CLOSEABLES = new ThreadLocal();
    private static final AtomicLong UUID_GENERATOR = new AtomicLong(Long.MIN_VALUE);
    private static final ThreadLocal<Integer> STACK_ID = new ThreadLocal();

    public static void setUp() {
        Integer currentStackId;
        if (ThreadContextFacade.stackedContextIsEmpty()) {
            STACKED_CONTEXT.set(new HashMap());
        }
        if (ThreadContextFacade.stackedCloseablesIsEmpty()) {
            STACKED_CLOSEABLES.set(new HashMap());
        }
        if ((currentStackId = STACK_ID.get()) == null) {
            STACK_ID.set(0);
        } else {
            STACK_ID.set(currentStackId + 1);
        }
        STACKED_CONTEXT.get().put(STACK_ID.get(), ThreadContextFacade.collectParentObjects());
        STACKED_CLOSEABLES.get().put(STACK_ID.get(), new HashMap());
        if (logger.isTraceEnabled()) {
            logger.trace("Scripting context {} has been set up", (Object)Thread.currentThread().hashCode());
        }
    }

    private static Map<String, Object> collectParentObjects() {
        HashMap<String, Object> allParentObjects = new HashMap<String, Object>();
        for (int parentStackId = STACK_ID.get() - 1; parentStackId >= 0; --parentStackId) {
            Map<String, Object> parentStackObjects = STACKED_CONTEXT.get().get(parentStackId);
            allParentObjects.putAll(parentStackObjects);
        }
        return allParentObjects;
    }

    public static void tearDown() {
        Integer stackId = STACK_ID.get();
        if (stackId == null) {
            return;
        }
        if (ThreadContextFacade.stackedContextIsNotEmpty()) {
            STACKED_CONTEXT.get().get(stackId).clear();
        }
        if (ThreadContextFacade.stackedCloseablesIsNotEmpty()) {
            Map<String, AutoCloseable> CLOSEABLES = STACKED_CLOSEABLES.get().get(stackId);
            for (Map.Entry<String, AutoCloseable> closeable : CLOSEABLES.entrySet()) {
                try {
                    if (logger.isErrorEnabled()) {
                        logger.error("Object of type {} from the context {} has not been closed properly.", (Object)closeable.getValue().getClass().getCanonicalName(), (Object)Thread.currentThread().hashCode());
                    }
                    closeable.getValue().close();
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            STACKED_CLOSEABLES.get().get(stackId).clear();
        }
        if (stackId == 0) {
            STACKED_CONTEXT.remove();
            STACKED_CLOSEABLES.remove();
        }
        STACK_ID.set(stackId - 1);
        if (logger.isTraceEnabled()) {
            logger.trace("Scripting context {} has been torn down", (Object)Thread.currentThread().hashCode());
        }
    }

    public static Object get(String key) throws ContextException {
        ThreadContextFacade.checkContext();
        Map<Integer, Map<String, Object>> stackedContext = STACKED_CONTEXT.get();
        Map<String, Object> currentStack = stackedContext.get(STACK_ID.get());
        return currentStack.get(key);
    }

    public static String set(Object value) throws ContextException {
        String uuid = ThreadContextFacade.generateObjectId();
        ThreadContextFacade.set(uuid, value);
        return uuid;
    }

    public static void set(String key, Object value) throws ContextException {
        ThreadContextFacade.checkContext();
        STACKED_CONTEXT.get().get(STACK_ID.get()).put(key, value);
        if (logger.isTraceEnabled()) {
            logger.trace("Context object has been added to {} with key {}", (Object)Thread.currentThread().hashCode(), (Object)key);
        }
    }

    public static void remove(String key) throws ContextException {
        ThreadContextFacade.checkContext();
        STACKED_CONTEXT.get().get(STACK_ID.get()).remove(key);
        if (logger.isTraceEnabled()) {
            logger.trace("Context object has been removed - key {}", (Object)key);
        }
    }

    private static void checkContext() throws ContextException {
        if (STACKED_CONTEXT.get() == null) {
            throw new ContextException("Context has not been initialized");
        }
    }

    public static boolean isValid() {
        return STACKED_CONTEXT.get() != null;
    }

    private static String generateObjectId() {
        return Long.toString(UUID_GENERATOR.incrementAndGet(), 36);
    }

    public static void addCloseable(AutoCloseable closeable) {
        if (STACKED_CLOSEABLES.get() != null) {
            STACKED_CLOSEABLES.get().get(STACK_ID.get()).put(STACK_ID.get() + "_" + closeable.hashCode(), closeable);
            if (logger.isTraceEnabled()) {
                logger.trace("Closeable object has been added to {} with hash {}", (Object)Thread.currentThread().hashCode(), (Object)closeable.hashCode());
            }
        }
    }

    public static void removeCloseable(AutoCloseable closeable) {
        if (STACKED_CLOSEABLES.get() != null) {
            STACKED_CLOSEABLES.get().get(STACK_ID.get()).remove(STACK_ID.get() + "_" + closeable.hashCode());
            if (logger.isTraceEnabled()) {
                logger.trace("Closeable object has been removed - hash {}", (Object)closeable.hashCode());
            }
        }
    }

    private static boolean stackedContextIsEmpty() {
        Map<Integer, Map<String, Object>> stackedContext = STACKED_CONTEXT.get();
        return stackedContext == null || stackedContext.isEmpty();
    }

    private static boolean stackedContextIsNotEmpty() {
        Map<Integer, Map<String, Object>> stackedContext = STACKED_CONTEXT.get();
        return stackedContext != null && !stackedContext.isEmpty();
    }

    private static boolean stackedCloseablesIsEmpty() {
        Map<Integer, Map<String, AutoCloseable>> stackedCloseables = STACKED_CLOSEABLES.get();
        return stackedCloseables == null || stackedCloseables.isEmpty();
    }

    private static boolean stackedCloseablesIsNotEmpty() {
        Map<Integer, Map<String, AutoCloseable>> stackedCloseables = STACKED_CLOSEABLES.get();
        return stackedCloseables != null && !stackedCloseables.isEmpty();
    }
}

