/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.api.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.dirigible.database.api.metadata.SchemaMetadata;
import org.eclipse.dirigible.databases.helpers.DatabaseMetadataHelper;

public class DatabaseMetadata {
    private boolean allProceduresAreCallable;
    private boolean allTablesAreSelectable;
    private String getURL;
    private String getUserName;
    private boolean isReadOnly;
    private boolean nullsAreSortedHigh;
    private boolean nullsAreSortedLow;
    private boolean nullsAreSortedAtStart;
    private boolean nullsAreSortedAtEnd;
    private String databaseProductName;
    private String databaseProductVersion;
    private String driverName;
    private String driverVersion;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private boolean usesLocalFiles;
    private boolean usesLocalFilePerTable;
    private boolean supportsMixedCaseIdentifiers;
    private boolean storesUpperCaseIdentifiers;
    private boolean storesLowerCaseIdentifiers;
    private boolean storesMixedCaseIdentifiers;
    private boolean supportsMixedCaseQuotedIdentifiers;
    private boolean storesUpperCaseQuotedIdentifiers;
    private boolean storesLowerCaseQuotedIdentifiers;
    private boolean storesMixedCaseQuotedIdentifiers;
    private String identifierQuoteString;
    private String sqlKeywords;
    private String numericFunctions;
    private String stringFunctions;
    private String systemFunctions;
    private String timeDateFunctions;
    private String searchStringEscape;
    private String extraNameCharacters;
    private boolean supportsAlterTableWithAddColumn;
    private boolean supportsAlterTableWithDropColumn;
    private boolean supportsColumnAliasing;
    private boolean nullPlusNonNullIsNull;
    private boolean supportsConvert;
    private boolean supportsTableCorrelationNames;
    private boolean supportsDifferentTableCorrelationNames;
    private boolean supportsExpressionsInOrderBy;
    private boolean supportsOrderByUnrelated;
    private boolean supportsGroupBy;
    private boolean supportsGroupByUnrelated;
    private boolean supportsGroupByBeyondSelect;
    private boolean supportsLikeEscapeClause;
    private boolean supportsMultipleResultSets;
    private boolean supportsMultipleTransactions;
    private boolean supportsNonNullableColumns;
    private boolean supportsMinimumSQLGrammar;
    private boolean supportsCoreSQLGrammar;
    private boolean supportsExtendedSQLGrammar;
    private boolean supportsANSI92EntryLevelSQL;
    private boolean supportsANSI92IntermediateSQL;
    private boolean supportsANSI92FullSQL;
    private boolean supportsIntegrityEnhancementFacility;
    private boolean supportsOuterJoins;
    private boolean supportsFullOuterJoins;
    private boolean supportsLimitedOuterJoins;
    private String schemaTerm;
    private String procedureTerm;
    private String catalogTerm;
    private boolean isCatalogAtStart;
    private String getCatalogSeparator;
    private boolean supportsSchemasInDataManipulation;
    private boolean supportsSchemasInProcedureCalls;
    private boolean supportsSchemasInTableDefinitions;
    private boolean supportsSchemasInIndexDefinitions;
    private boolean supportsSchemasInPrivilegeDefinitions;
    private boolean supportsCatalogsInDataManipulation;
    private boolean supportsCatalogsInProcedureCalls;
    private boolean supportsCatalogsInTableDefinitions;
    private boolean supportsCatalogsInIndexDefinitions;
    private boolean supportsCatalogsInPrivilegeDefinitions;
    private boolean supportsPositionedDelete;
    private boolean supportsPositionedUpdate;
    private boolean supportsSelectForUpdate;
    private boolean supportsStoredProcedures;
    private boolean supportsSubqueriesInComparisons;
    private boolean supportsSubqueriesInExists;
    private boolean supportsSubqueriesInIns;
    private boolean supportsSubqueriesInQuantifieds;
    private boolean supportsCorrelatedSubqueries;
    private boolean supportsUnion;
    private boolean supportsUnionAll;
    private boolean supportsOpenCursorsAcrossCommit;
    private boolean supportsOpenCursorsAcrossRollback;
    private boolean supportsOpenStatementsAcrossCommit;
    private boolean supportsOpenStatementsAcrossRollback;
    private int maxBinaryLiteralLength;
    private int maxCharLiteralLength;
    private int maxColumnNameLength;
    private int maxColumnsInGroupBy;
    private int maxColumnsInIndex;
    private int maxColumnsInOrderBy;
    private int maxColumnsInSelect;
    private int maxColumnsInTable;
    private int maxConnections;
    private int maxCursorNameLength;
    private int maxIndexLength;
    private int maxSchemaNameLength;
    private int maxProcedureNameLength;
    private int maxCatalogNameLength;
    private int maxRowSize;
    private boolean maxRowSizeIncludeBlobs;
    private int maxStatementLength;
    private int maxStatements;
    private int maxTableNameLength;
    private int maxTablesInSelect;
    private int maxUserNameLength;
    private int defaultTransactionIsolation;
    private boolean supportsTransactions;
    private boolean supportsDataDefinitionAndDataManipulationTransactions;
    private boolean supportsDataManipulationTransactionsOnly;
    private boolean dataDefinitionCausesTransactionCommit;
    private boolean dataDefinitionIgnoredInTransactions;
    private boolean supportsBatchUpdates;
    private boolean supportsSavepoints;
    private boolean supportsNamedParameters;
    private boolean supportsMultipleOpenResults;
    private boolean supportsGetGeneratedKeys;
    private int getResultSetHoldability;
    private int getDatabaseMajorVersion;
    private int getDatabaseMinorVersion;
    private int getJDBCMajorVersion;
    private int getJDBCMinorVersion;
    private int getSQLStateType;
    private boolean locatorsUpdateCopy;
    private boolean supportsStatementPooling;
    private boolean supportsStoredFunctionsUsingCallSyntax;
    private boolean autoCommitFailureClosesAllResultSets;
    private boolean generatedKeyAlwaysReturned;
    private long getMaxLogicalLobSize;
    private boolean supportsRefCursors;
    private List<SchemaMetadata> schemas;
    private String kind = "database";

    public DatabaseMetadata(Connection connection, String catalogName, DatabaseMetadataHelper.Filter<String> schemaNameFilter, DatabaseMetadataHelper.Filter<String> tableNameFilter) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.allProceduresAreCallable = databaseMetaData.allProceduresAreCallable();
        this.allTablesAreSelectable = databaseMetaData.allTablesAreSelectable();
        this.getURL = databaseMetaData.getURL();
        this.getUserName = databaseMetaData.getUserName();
        this.isReadOnly = databaseMetaData.isReadOnly();
        this.nullsAreSortedHigh = databaseMetaData.nullsAreSortedHigh();
        this.nullsAreSortedLow = databaseMetaData.nullsAreSortedLow();
        this.nullsAreSortedAtStart = databaseMetaData.nullsAreSortedAtStart();
        this.nullsAreSortedAtEnd = databaseMetaData.nullsAreSortedAtEnd();
        this.databaseProductName = databaseMetaData.getDatabaseProductName();
        this.databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
        this.driverName = databaseMetaData.getDriverName();
        this.driverVersion = databaseMetaData.getDriverVersion();
        this.driverMajorVersion = databaseMetaData.getDriverMajorVersion();
        this.driverMinorVersion = databaseMetaData.getDriverMinorVersion();
        this.usesLocalFiles = databaseMetaData.usesLocalFiles();
        this.usesLocalFilePerTable = databaseMetaData.usesLocalFilePerTable();
        this.supportsMixedCaseIdentifiers = databaseMetaData.supportsMixedCaseIdentifiers();
        this.storesUpperCaseIdentifiers = databaseMetaData.storesUpperCaseIdentifiers();
        this.storesLowerCaseIdentifiers = databaseMetaData.storesLowerCaseIdentifiers();
        this.storesMixedCaseIdentifiers = databaseMetaData.storesMixedCaseIdentifiers();
        this.supportsMixedCaseQuotedIdentifiers = databaseMetaData.supportsMixedCaseQuotedIdentifiers();
        this.storesUpperCaseQuotedIdentifiers = databaseMetaData.storesUpperCaseQuotedIdentifiers();
        this.storesLowerCaseQuotedIdentifiers = databaseMetaData.storesLowerCaseQuotedIdentifiers();
        this.storesMixedCaseQuotedIdentifiers = databaseMetaData.storesMixedCaseQuotedIdentifiers();
        this.identifierQuoteString = databaseMetaData.getIdentifierQuoteString();
        this.sqlKeywords = databaseMetaData.getSQLKeywords();
        this.numericFunctions = databaseMetaData.getNumericFunctions();
        this.stringFunctions = databaseMetaData.getStringFunctions();
        this.systemFunctions = databaseMetaData.getSystemFunctions();
        this.timeDateFunctions = databaseMetaData.getTimeDateFunctions();
        this.searchStringEscape = databaseMetaData.getSearchStringEscape();
        this.extraNameCharacters = databaseMetaData.getExtraNameCharacters();
        this.supportsAlterTableWithAddColumn = databaseMetaData.supportsAlterTableWithAddColumn();
        this.supportsAlterTableWithDropColumn = databaseMetaData.supportsAlterTableWithDropColumn();
        this.supportsColumnAliasing = databaseMetaData.supportsColumnAliasing();
        this.nullPlusNonNullIsNull = databaseMetaData.nullPlusNonNullIsNull();
        this.supportsConvert = databaseMetaData.supportsConvert();
        this.supportsTableCorrelationNames = databaseMetaData.supportsTableCorrelationNames();
        this.supportsDifferentTableCorrelationNames = databaseMetaData.supportsDifferentTableCorrelationNames();
        this.supportsExpressionsInOrderBy = databaseMetaData.supportsExpressionsInOrderBy();
        this.supportsOrderByUnrelated = databaseMetaData.supportsOrderByUnrelated();
        this.supportsGroupBy = databaseMetaData.supportsGroupBy();
        this.supportsGroupByUnrelated = databaseMetaData.supportsGroupByUnrelated();
        this.supportsGroupByBeyondSelect = databaseMetaData.supportsGroupByBeyondSelect();
        this.supportsLikeEscapeClause = databaseMetaData.supportsLikeEscapeClause();
        this.supportsMultipleResultSets = databaseMetaData.supportsMultipleResultSets();
        this.supportsMultipleTransactions = databaseMetaData.supportsMultipleTransactions();
        this.supportsNonNullableColumns = databaseMetaData.supportsNonNullableColumns();
        this.supportsMinimumSQLGrammar = databaseMetaData.supportsMinimumSQLGrammar();
        this.supportsCoreSQLGrammar = databaseMetaData.supportsCoreSQLGrammar();
        this.supportsExtendedSQLGrammar = databaseMetaData.supportsExtendedSQLGrammar();
        this.supportsANSI92EntryLevelSQL = databaseMetaData.supportsANSI92EntryLevelSQL();
        this.supportsANSI92IntermediateSQL = databaseMetaData.supportsANSI92IntermediateSQL();
        this.supportsANSI92FullSQL = databaseMetaData.supportsANSI92FullSQL();
        this.supportsIntegrityEnhancementFacility = databaseMetaData.supportsIntegrityEnhancementFacility();
        this.supportsOuterJoins = databaseMetaData.supportsOuterJoins();
        this.supportsFullOuterJoins = databaseMetaData.supportsFullOuterJoins();
        this.supportsLimitedOuterJoins = databaseMetaData.supportsLimitedOuterJoins();
        this.schemaTerm = databaseMetaData.getSchemaTerm();
        this.procedureTerm = databaseMetaData.getProcedureTerm();
        this.catalogTerm = databaseMetaData.getCatalogTerm();
        this.isCatalogAtStart = databaseMetaData.isCatalogAtStart();
        this.getCatalogSeparator = databaseMetaData.getCatalogSeparator();
        this.supportsSchemasInDataManipulation = databaseMetaData.supportsSchemasInDataManipulation();
        this.supportsSchemasInProcedureCalls = databaseMetaData.supportsSchemasInProcedureCalls();
        this.supportsSchemasInTableDefinitions = databaseMetaData.supportsSchemasInTableDefinitions();
        this.supportsSchemasInIndexDefinitions = databaseMetaData.supportsSchemasInIndexDefinitions();
        this.supportsSchemasInPrivilegeDefinitions = databaseMetaData.supportsSchemasInPrivilegeDefinitions();
        this.supportsCatalogsInDataManipulation = databaseMetaData.supportsCatalogsInDataManipulation();
        this.supportsCatalogsInProcedureCalls = databaseMetaData.supportsCatalogsInProcedureCalls();
        this.supportsCatalogsInTableDefinitions = databaseMetaData.supportsCatalogsInTableDefinitions();
        this.supportsCatalogsInIndexDefinitions = databaseMetaData.supportsCatalogsInIndexDefinitions();
        this.supportsCatalogsInPrivilegeDefinitions = databaseMetaData.supportsCatalogsInPrivilegeDefinitions();
        this.supportsPositionedDelete = databaseMetaData.supportsPositionedDelete();
        this.supportsPositionedUpdate = databaseMetaData.supportsPositionedUpdate();
        this.supportsSelectForUpdate = databaseMetaData.supportsSelectForUpdate();
        this.supportsStoredProcedures = databaseMetaData.supportsStoredProcedures();
        this.supportsSubqueriesInComparisons = databaseMetaData.supportsSubqueriesInComparisons();
        this.supportsSubqueriesInExists = databaseMetaData.supportsSubqueriesInExists();
        this.supportsSubqueriesInIns = databaseMetaData.supportsSubqueriesInIns();
        this.supportsSubqueriesInQuantifieds = databaseMetaData.supportsSubqueriesInQuantifieds();
        this.supportsCorrelatedSubqueries = databaseMetaData.supportsCorrelatedSubqueries();
        this.supportsUnion = databaseMetaData.supportsUnion();
        this.supportsUnionAll = databaseMetaData.supportsUnionAll();
        this.supportsOpenCursorsAcrossCommit = databaseMetaData.supportsOpenCursorsAcrossCommit();
        this.supportsOpenCursorsAcrossRollback = databaseMetaData.supportsOpenCursorsAcrossRollback();
        this.supportsOpenStatementsAcrossCommit = databaseMetaData.supportsOpenStatementsAcrossCommit();
        this.supportsOpenStatementsAcrossRollback = databaseMetaData.supportsOpenStatementsAcrossRollback();
        this.maxBinaryLiteralLength = databaseMetaData.getMaxBinaryLiteralLength();
        this.maxCharLiteralLength = databaseMetaData.getMaxCharLiteralLength();
        this.maxColumnNameLength = databaseMetaData.getMaxColumnNameLength();
        this.maxColumnsInGroupBy = databaseMetaData.getMaxColumnsInGroupBy();
        this.maxColumnsInIndex = databaseMetaData.getMaxColumnsInIndex();
        this.maxColumnsInOrderBy = databaseMetaData.getMaxColumnsInOrderBy();
        this.maxColumnsInSelect = databaseMetaData.getMaxColumnsInSelect();
        this.maxColumnsInTable = databaseMetaData.getMaxColumnsInTable();
        this.maxConnections = databaseMetaData.getMaxConnections();
        this.maxCursorNameLength = databaseMetaData.getMaxCursorNameLength();
        this.maxIndexLength = databaseMetaData.getMaxIndexLength();
        this.maxSchemaNameLength = databaseMetaData.getMaxSchemaNameLength();
        this.maxProcedureNameLength = databaseMetaData.getMaxProcedureNameLength();
        this.maxCatalogNameLength = databaseMetaData.getMaxCatalogNameLength();
        this.maxRowSize = databaseMetaData.getMaxRowSize();
        this.maxRowSizeIncludeBlobs = databaseMetaData.doesMaxRowSizeIncludeBlobs();
        this.maxStatementLength = databaseMetaData.getMaxStatementLength();
        this.maxStatements = databaseMetaData.getMaxStatements();
        this.maxTableNameLength = databaseMetaData.getMaxTableNameLength();
        this.maxTablesInSelect = databaseMetaData.getMaxTablesInSelect();
        this.maxUserNameLength = databaseMetaData.getMaxUserNameLength();
        this.defaultTransactionIsolation = databaseMetaData.getDefaultTransactionIsolation();
        this.supportsTransactions = databaseMetaData.supportsTransactions();
        this.supportsDataDefinitionAndDataManipulationTransactions = databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions();
        this.supportsDataManipulationTransactionsOnly = databaseMetaData.supportsDataManipulationTransactionsOnly();
        this.dataDefinitionCausesTransactionCommit = databaseMetaData.dataDefinitionCausesTransactionCommit();
        this.dataDefinitionIgnoredInTransactions = databaseMetaData.dataDefinitionIgnoredInTransactions();
        this.supportsBatchUpdates = databaseMetaData.supportsBatchUpdates();
        this.supportsSavepoints = databaseMetaData.supportsSavepoints();
        this.supportsNamedParameters = databaseMetaData.supportsNamedParameters();
        this.supportsMultipleOpenResults = databaseMetaData.supportsMultipleOpenResults();
        this.supportsGetGeneratedKeys = databaseMetaData.supportsGetGeneratedKeys();
        this.getResultSetHoldability = databaseMetaData.getResultSetHoldability();
        this.getDatabaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
        this.getDatabaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
        this.getJDBCMajorVersion = databaseMetaData.getJDBCMajorVersion();
        this.getJDBCMinorVersion = databaseMetaData.getJDBCMinorVersion();
        this.getSQLStateType = databaseMetaData.getSQLStateType();
        this.locatorsUpdateCopy = databaseMetaData.locatorsUpdateCopy();
        this.supportsStatementPooling = databaseMetaData.supportsStatementPooling();
        this.supportsStoredFunctionsUsingCallSyntax = databaseMetaData.supportsStoredFunctionsUsingCallSyntax();
        this.autoCommitFailureClosesAllResultSets = databaseMetaData.autoCommitFailureClosesAllResultSets();
        try {
            this.generatedKeyAlwaysReturned = databaseMetaData.generatedKeyAlwaysReturned();
        }
        catch (Throwable e) {
            this.generatedKeyAlwaysReturned = false;
        }
        this.getMaxLogicalLobSize = databaseMetaData.getMaxLogicalLobSize();
        this.supportsRefCursors = databaseMetaData.supportsRefCursors();
        this.schemas = DatabaseMetadataHelper.listSchemas(connection, catalogName, schemaNameFilter, tableNameFilter);
    }

    public boolean isAllProceduresAreCallable() {
        return this.allProceduresAreCallable;
    }

    public void setAllProceduresAreCallable(boolean allProceduresAreCallable) {
        this.allProceduresAreCallable = allProceduresAreCallable;
    }

    public boolean isAllTablesAreSelectable() {
        return this.allTablesAreSelectable;
    }

    public void setAllTablesAreSelectable(boolean allTablesAreSelectable) {
        this.allTablesAreSelectable = allTablesAreSelectable;
    }

    public String getGetURL() {
        return this.getURL;
    }

    public void setGetURL(String getURL) {
        this.getURL = getURL;
    }

    public String getGetUserName() {
        return this.getUserName;
    }

    public void setGetUserName(String getUserName) {
        this.getUserName = getUserName;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isNullsAreSortedHigh() {
        return this.nullsAreSortedHigh;
    }

    public void setNullsAreSortedHigh(boolean nullsAreSortedHigh) {
        this.nullsAreSortedHigh = nullsAreSortedHigh;
    }

    public boolean isNullsAreSortedLow() {
        return this.nullsAreSortedLow;
    }

    public void setNullsAreSortedLow(boolean nullsAreSortedLow) {
        this.nullsAreSortedLow = nullsAreSortedLow;
    }

    public boolean isNullsAreSortedAtStart() {
        return this.nullsAreSortedAtStart;
    }

    public void setNullsAreSortedAtStart(boolean nullsAreSortedAtStart) {
        this.nullsAreSortedAtStart = nullsAreSortedAtStart;
    }

    public boolean isNullsAreSortedAtEnd() {
        return this.nullsAreSortedAtEnd;
    }

    public void setNullsAreSortedAtEnd(boolean nullsAreSortedAtEnd) {
        this.nullsAreSortedAtEnd = nullsAreSortedAtEnd;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public void setDriverMajorVersion(int driverMajorVersion) {
        this.driverMajorVersion = driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public void setDriverMinorVersion(int driverMinorVersion) {
        this.driverMinorVersion = driverMinorVersion;
    }

    public boolean isUsesLocalFiles() {
        return this.usesLocalFiles;
    }

    public void setUsesLocalFiles(boolean usesLocalFiles) {
        this.usesLocalFiles = usesLocalFiles;
    }

    public boolean isUsesLocalFilePerTable() {
        return this.usesLocalFilePerTable;
    }

    public void setUsesLocalFilePerTable(boolean usesLocalFilePerTable) {
        this.usesLocalFilePerTable = usesLocalFilePerTable;
    }

    public boolean isSupportsMixedCaseIdentifiers() {
        return this.supportsMixedCaseIdentifiers;
    }

    public void setSupportsMixedCaseIdentifiers(boolean supportsMixedCaseIdentifiers) {
        this.supportsMixedCaseIdentifiers = supportsMixedCaseIdentifiers;
    }

    public boolean isStoresUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    public void setStoresUpperCaseIdentifiers(boolean storesUpperCaseIdentifiers) {
        this.storesUpperCaseIdentifiers = storesUpperCaseIdentifiers;
    }

    public boolean isStoresLowerCaseIdentifiers() {
        return this.storesLowerCaseIdentifiers;
    }

    public void setStoresLowerCaseIdentifiers(boolean storesLowerCaseIdentifiers) {
        this.storesLowerCaseIdentifiers = storesLowerCaseIdentifiers;
    }

    public boolean isStoresMixedCaseIdentifiers() {
        return this.storesMixedCaseIdentifiers;
    }

    public void setStoresMixedCaseIdentifiers(boolean storesMixedCaseIdentifiers) {
        this.storesMixedCaseIdentifiers = storesMixedCaseIdentifiers;
    }

    public boolean isSupportsMixedCaseQuotedIdentifiers() {
        return this.supportsMixedCaseQuotedIdentifiers;
    }

    public void setSupportsMixedCaseQuotedIdentifiers(boolean supportsMixedCaseQuotedIdentifiers) {
        this.supportsMixedCaseQuotedIdentifiers = supportsMixedCaseQuotedIdentifiers;
    }

    public boolean isStoresUpperCaseQuotedIdentifiers() {
        return this.storesUpperCaseQuotedIdentifiers;
    }

    public void setStoresUpperCaseQuotedIdentifiers(boolean storesUpperCaseQuotedIdentifiers) {
        this.storesUpperCaseQuotedIdentifiers = storesUpperCaseQuotedIdentifiers;
    }

    public boolean isStoresLowerCaseQuotedIdentifiers() {
        return this.storesLowerCaseQuotedIdentifiers;
    }

    public void setStoresLowerCaseQuotedIdentifiers(boolean storesLowerCaseQuotedIdentifiers) {
        this.storesLowerCaseQuotedIdentifiers = storesLowerCaseQuotedIdentifiers;
    }

    public boolean isStoresMixedCaseQuotedIdentifiers() {
        return this.storesMixedCaseQuotedIdentifiers;
    }

    public void setStoresMixedCaseQuotedIdentifiers(boolean storesMixedCaseQuotedIdentifiers) {
        this.storesMixedCaseQuotedIdentifiers = storesMixedCaseQuotedIdentifiers;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public void setIdentifierQuoteString(String identifierQuoteString) {
        this.identifierQuoteString = identifierQuoteString;
    }

    public String getSqlKeywords() {
        return this.sqlKeywords;
    }

    public void setSqlKeywords(String sqlKeywords) {
        this.sqlKeywords = sqlKeywords;
    }

    public String getNumericFunctions() {
        return this.numericFunctions;
    }

    public void setNumericFunctions(String numericFunctions) {
        this.numericFunctions = numericFunctions;
    }

    public String getStringFunctions() {
        return this.stringFunctions;
    }

    public void setStringFunctions(String stringFunctions) {
        this.stringFunctions = stringFunctions;
    }

    public String getSystemFunctions() {
        return this.systemFunctions;
    }

    public void setSystemFunctions(String systemFunctions) {
        this.systemFunctions = systemFunctions;
    }

    public String getTimeDateFunctions() {
        return this.timeDateFunctions;
    }

    public void setTimeDateFunctions(String timeDateFunctions) {
        this.timeDateFunctions = timeDateFunctions;
    }

    public String getSearchStringEscape() {
        return this.searchStringEscape;
    }

    public void setSearchStringEscape(String searchStringEscape) {
        this.searchStringEscape = searchStringEscape;
    }

    public String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    public void setExtraNameCharacters(String extraNameCharacters) {
        this.extraNameCharacters = extraNameCharacters;
    }

    public boolean isSupportsAlterTableWithAddColumn() {
        return this.supportsAlterTableWithAddColumn;
    }

    public void setSupportsAlterTableWithAddColumn(boolean supportsAlterTableWithAddColumn) {
        this.supportsAlterTableWithAddColumn = supportsAlterTableWithAddColumn;
    }

    public boolean isSupportsAlterTableWithDropColumn() {
        return this.supportsAlterTableWithDropColumn;
    }

    public void setSupportsAlterTableWithDropColumn(boolean supportsAlterTableWithDropColumn) {
        this.supportsAlterTableWithDropColumn = supportsAlterTableWithDropColumn;
    }

    public boolean isSupportsColumnAliasing() {
        return this.supportsColumnAliasing;
    }

    public void setSupportsColumnAliasing(boolean supportsColumnAliasing) {
        this.supportsColumnAliasing = supportsColumnAliasing;
    }

    public boolean isNullPlusNonNullIsNull() {
        return this.nullPlusNonNullIsNull;
    }

    public void setNullPlusNonNullIsNull(boolean nullPlusNonNullIsNull) {
        this.nullPlusNonNullIsNull = nullPlusNonNullIsNull;
    }

    public boolean isSupportsConvert() {
        return this.supportsConvert;
    }

    public void setSupportsConvert(boolean supportsConvert) {
        this.supportsConvert = supportsConvert;
    }

    public boolean isSupportsTableCorrelationNames() {
        return this.supportsTableCorrelationNames;
    }

    public void setSupportsTableCorrelationNames(boolean supportsTableCorrelationNames) {
        this.supportsTableCorrelationNames = supportsTableCorrelationNames;
    }

    public boolean isSupportsDifferentTableCorrelationNames() {
        return this.supportsDifferentTableCorrelationNames;
    }

    public void setSupportsDifferentTableCorrelationNames(boolean supportsDifferentTableCorrelationNames) {
        this.supportsDifferentTableCorrelationNames = supportsDifferentTableCorrelationNames;
    }

    public boolean isSupportsExpressionsInOrderBy() {
        return this.supportsExpressionsInOrderBy;
    }

    public void setSupportsExpressionsInOrderBy(boolean supportsExpressionsInOrderBy) {
        this.supportsExpressionsInOrderBy = supportsExpressionsInOrderBy;
    }

    public boolean isSupportsOrderByUnrelated() {
        return this.supportsOrderByUnrelated;
    }

    public void setSupportsOrderByUnrelated(boolean supportsOrderByUnrelated) {
        this.supportsOrderByUnrelated = supportsOrderByUnrelated;
    }

    public boolean isSupportsGroupBy() {
        return this.supportsGroupBy;
    }

    public void setSupportsGroupBy(boolean supportsGroupBy) {
        this.supportsGroupBy = supportsGroupBy;
    }

    public boolean isSupportsGroupByUnrelated() {
        return this.supportsGroupByUnrelated;
    }

    public void setSupportsGroupByUnrelated(boolean supportsGroupByUnrelated) {
        this.supportsGroupByUnrelated = supportsGroupByUnrelated;
    }

    public boolean isSupportsGroupByBeyondSelect() {
        return this.supportsGroupByBeyondSelect;
    }

    public void setSupportsGroupByBeyondSelect(boolean supportsGroupByBeyondSelect) {
        this.supportsGroupByBeyondSelect = supportsGroupByBeyondSelect;
    }

    public boolean isSupportsLikeEscapeClause() {
        return this.supportsLikeEscapeClause;
    }

    public void setSupportsLikeEscapeClause(boolean supportsLikeEscapeClause) {
        this.supportsLikeEscapeClause = supportsLikeEscapeClause;
    }

    public boolean isSupportsMultipleResultSets() {
        return this.supportsMultipleResultSets;
    }

    public void setSupportsMultipleResultSets(boolean supportsMultipleResultSets) {
        this.supportsMultipleResultSets = supportsMultipleResultSets;
    }

    public boolean isSupportsMultipleTransactions() {
        return this.supportsMultipleTransactions;
    }

    public void setSupportsMultipleTransactions(boolean supportsMultipleTransactions) {
        this.supportsMultipleTransactions = supportsMultipleTransactions;
    }

    public boolean isSupportsNonNullableColumns() {
        return this.supportsNonNullableColumns;
    }

    public void setSupportsNonNullableColumns(boolean supportsNonNullableColumns) {
        this.supportsNonNullableColumns = supportsNonNullableColumns;
    }

    public boolean isSupportsMinimumSQLGrammar() {
        return this.supportsMinimumSQLGrammar;
    }

    public void setSupportsMinimumSQLGrammar(boolean supportsMinimumSQLGrammar) {
        this.supportsMinimumSQLGrammar = supportsMinimumSQLGrammar;
    }

    public boolean isSupportsCoreSQLGrammar() {
        return this.supportsCoreSQLGrammar;
    }

    public void setSupportsCoreSQLGrammar(boolean supportsCoreSQLGrammar) {
        this.supportsCoreSQLGrammar = supportsCoreSQLGrammar;
    }

    public boolean isSupportsExtendedSQLGrammar() {
        return this.supportsExtendedSQLGrammar;
    }

    public void setSupportsExtendedSQLGrammar(boolean supportsExtendedSQLGrammar) {
        this.supportsExtendedSQLGrammar = supportsExtendedSQLGrammar;
    }

    public boolean isSupportsANSI92EntryLevelSQL() {
        return this.supportsANSI92EntryLevelSQL;
    }

    public void setSupportsANSI92EntryLevelSQL(boolean supportsANSI92EntryLevelSQL) {
        this.supportsANSI92EntryLevelSQL = supportsANSI92EntryLevelSQL;
    }

    public boolean isSupportsANSI92IntermediateSQL() {
        return this.supportsANSI92IntermediateSQL;
    }

    public void setSupportsANSI92IntermediateSQL(boolean supportsANSI92IntermediateSQL) {
        this.supportsANSI92IntermediateSQL = supportsANSI92IntermediateSQL;
    }

    public boolean isSupportsANSI92FullSQL() {
        return this.supportsANSI92FullSQL;
    }

    public void setSupportsANSI92FullSQL(boolean supportsANSI92FullSQL) {
        this.supportsANSI92FullSQL = supportsANSI92FullSQL;
    }

    public boolean isSupportsIntegrityEnhancementFacility() {
        return this.supportsIntegrityEnhancementFacility;
    }

    public void setSupportsIntegrityEnhancementFacility(boolean supportsIntegrityEnhancementFacility) {
        this.supportsIntegrityEnhancementFacility = supportsIntegrityEnhancementFacility;
    }

    public boolean isSupportsOuterJoins() {
        return this.supportsOuterJoins;
    }

    public void setSupportsOuterJoins(boolean supportsOuterJoins) {
        this.supportsOuterJoins = supportsOuterJoins;
    }

    public boolean isSupportsFullOuterJoins() {
        return this.supportsFullOuterJoins;
    }

    public void setSupportsFullOuterJoins(boolean supportsFullOuterJoins) {
        this.supportsFullOuterJoins = supportsFullOuterJoins;
    }

    public boolean isSupportsLimitedOuterJoins() {
        return this.supportsLimitedOuterJoins;
    }

    public void setSupportsLimitedOuterJoins(boolean supportsLimitedOuterJoins) {
        this.supportsLimitedOuterJoins = supportsLimitedOuterJoins;
    }

    public String getSchemaTerm() {
        return this.schemaTerm;
    }

    public void setSchemaTerm(String schemaTerm) {
        this.schemaTerm = schemaTerm;
    }

    public String getProcedureTerm() {
        return this.procedureTerm;
    }

    public void setProcedureTerm(String procedureTerm) {
        this.procedureTerm = procedureTerm;
    }

    public String getCatalogTerm() {
        return this.catalogTerm;
    }

    public void setCatalogTerm(String catalogTerm) {
        this.catalogTerm = catalogTerm;
    }

    public boolean isCatalogAtStart() {
        return this.isCatalogAtStart;
    }

    public void setCatalogAtStart(boolean isCatalogAtStart) {
        this.isCatalogAtStart = isCatalogAtStart;
    }

    public String getGetCatalogSeparator() {
        return this.getCatalogSeparator;
    }

    public void setGetCatalogSeparator(String getCatalogSeparator) {
        this.getCatalogSeparator = getCatalogSeparator;
    }

    public boolean isSupportsSchemasInDataManipulation() {
        return this.supportsSchemasInDataManipulation;
    }

    public void setSupportsSchemasInDataManipulation(boolean supportsSchemasInDataManipulation) {
        this.supportsSchemasInDataManipulation = supportsSchemasInDataManipulation;
    }

    public boolean isSupportsSchemasInProcedureCalls() {
        return this.supportsSchemasInProcedureCalls;
    }

    public void setSupportsSchemasInProcedureCalls(boolean supportsSchemasInProcedureCalls) {
        this.supportsSchemasInProcedureCalls = supportsSchemasInProcedureCalls;
    }

    public boolean isSupportsSchemasInTableDefinitions() {
        return this.supportsSchemasInTableDefinitions;
    }

    public void setSupportsSchemasInTableDefinitions(boolean supportsSchemasInTableDefinitions) {
        this.supportsSchemasInTableDefinitions = supportsSchemasInTableDefinitions;
    }

    public boolean isSupportsSchemasInIndexDefinitions() {
        return this.supportsSchemasInIndexDefinitions;
    }

    public void setSupportsSchemasInIndexDefinitions(boolean supportsSchemasInIndexDefinitions) {
        this.supportsSchemasInIndexDefinitions = supportsSchemasInIndexDefinitions;
    }

    public boolean isSupportsSchemasInPrivilegeDefinitions() {
        return this.supportsSchemasInPrivilegeDefinitions;
    }

    public void setSupportsSchemasInPrivilegeDefinitions(boolean supportsSchemasInPrivilegeDefinitions) {
        this.supportsSchemasInPrivilegeDefinitions = supportsSchemasInPrivilegeDefinitions;
    }

    public boolean isSupportsCatalogsInDataManipulation() {
        return this.supportsCatalogsInDataManipulation;
    }

    public void setSupportsCatalogsInDataManipulation(boolean supportsCatalogsInDataManipulation) {
        this.supportsCatalogsInDataManipulation = supportsCatalogsInDataManipulation;
    }

    public boolean isSupportsCatalogsInProcedureCalls() {
        return this.supportsCatalogsInProcedureCalls;
    }

    public void setSupportsCatalogsInProcedureCalls(boolean supportsCatalogsInProcedureCalls) {
        this.supportsCatalogsInProcedureCalls = supportsCatalogsInProcedureCalls;
    }

    public boolean isSupportsCatalogsInTableDefinitions() {
        return this.supportsCatalogsInTableDefinitions;
    }

    public void setSupportsCatalogsInTableDefinitions(boolean supportsCatalogsInTableDefinitions) {
        this.supportsCatalogsInTableDefinitions = supportsCatalogsInTableDefinitions;
    }

    public boolean isSupportsCatalogsInIndexDefinitions() {
        return this.supportsCatalogsInIndexDefinitions;
    }

    public void setSupportsCatalogsInIndexDefinitions(boolean supportsCatalogsInIndexDefinitions) {
        this.supportsCatalogsInIndexDefinitions = supportsCatalogsInIndexDefinitions;
    }

    public boolean isSupportsCatalogsInPrivilegeDefinitions() {
        return this.supportsCatalogsInPrivilegeDefinitions;
    }

    public void setSupportsCatalogsInPrivilegeDefinitions(boolean supportsCatalogsInPrivilegeDefinitions) {
        this.supportsCatalogsInPrivilegeDefinitions = supportsCatalogsInPrivilegeDefinitions;
    }

    public boolean isSupportsPositionedDelete() {
        return this.supportsPositionedDelete;
    }

    public void setSupportsPositionedDelete(boolean supportsPositionedDelete) {
        this.supportsPositionedDelete = supportsPositionedDelete;
    }

    public boolean isSupportsPositionedUpdate() {
        return this.supportsPositionedUpdate;
    }

    public void setSupportsPositionedUpdate(boolean supportsPositionedUpdate) {
        this.supportsPositionedUpdate = supportsPositionedUpdate;
    }

    public boolean isSupportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    public void setSupportsSelectForUpdate(boolean supportsSelectForUpdate) {
        this.supportsSelectForUpdate = supportsSelectForUpdate;
    }

    public boolean isSupportsStoredProcedures() {
        return this.supportsStoredProcedures;
    }

    public void setSupportsStoredProcedures(boolean supportsStoredProcedures) {
        this.supportsStoredProcedures = supportsStoredProcedures;
    }

    public boolean isSupportsSubqueriesInComparisons() {
        return this.supportsSubqueriesInComparisons;
    }

    public void setSupportsSubqueriesInComparisons(boolean supportsSubqueriesInComparisons) {
        this.supportsSubqueriesInComparisons = supportsSubqueriesInComparisons;
    }

    public boolean isSupportsSubqueriesInExists() {
        return this.supportsSubqueriesInExists;
    }

    public void setSupportsSubqueriesInExists(boolean supportsSubqueriesInExists) {
        this.supportsSubqueriesInExists = supportsSubqueriesInExists;
    }

    public boolean isSupportsSubqueriesInIns() {
        return this.supportsSubqueriesInIns;
    }

    public void setSupportsSubqueriesInIns(boolean supportsSubqueriesInIns) {
        this.supportsSubqueriesInIns = supportsSubqueriesInIns;
    }

    public boolean isSupportsSubqueriesInQuantifieds() {
        return this.supportsSubqueriesInQuantifieds;
    }

    public void setSupportsSubqueriesInQuantifieds(boolean supportsSubqueriesInQuantifieds) {
        this.supportsSubqueriesInQuantifieds = supportsSubqueriesInQuantifieds;
    }

    public boolean isSupportsCorrelatedSubqueries() {
        return this.supportsCorrelatedSubqueries;
    }

    public void setSupportsCorrelatedSubqueries(boolean supportsCorrelatedSubqueries) {
        this.supportsCorrelatedSubqueries = supportsCorrelatedSubqueries;
    }

    public boolean isSupportsUnion() {
        return this.supportsUnion;
    }

    public void setSupportsUnion(boolean supportsUnion) {
        this.supportsUnion = supportsUnion;
    }

    public boolean isSupportsUnionAll() {
        return this.supportsUnionAll;
    }

    public void setSupportsUnionAll(boolean supportsUnionAll) {
        this.supportsUnionAll = supportsUnionAll;
    }

    public boolean isSupportsOpenCursorsAcrossCommit() {
        return this.supportsOpenCursorsAcrossCommit;
    }

    public void setSupportsOpenCursorsAcrossCommit(boolean supportsOpenCursorsAcrossCommit) {
        this.supportsOpenCursorsAcrossCommit = supportsOpenCursorsAcrossCommit;
    }

    public boolean isSupportsOpenCursorsAcrossRollback() {
        return this.supportsOpenCursorsAcrossRollback;
    }

    public void setSupportsOpenCursorsAcrossRollback(boolean supportsOpenCursorsAcrossRollback) {
        this.supportsOpenCursorsAcrossRollback = supportsOpenCursorsAcrossRollback;
    }

    public boolean isSupportsOpenStatementsAcrossCommit() {
        return this.supportsOpenStatementsAcrossCommit;
    }

    public void setSupportsOpenStatementsAcrossCommit(boolean supportsOpenStatementsAcrossCommit) {
        this.supportsOpenStatementsAcrossCommit = supportsOpenStatementsAcrossCommit;
    }

    public boolean isSupportsOpenStatementsAcrossRollback() {
        return this.supportsOpenStatementsAcrossRollback;
    }

    public void setSupportsOpenStatementsAcrossRollback(boolean supportsOpenStatementsAcrossRollback) {
        this.supportsOpenStatementsAcrossRollback = supportsOpenStatementsAcrossRollback;
    }

    public int getMaxBinaryLiteralLength() {
        return this.maxBinaryLiteralLength;
    }

    public void setMaxBinaryLiteralLength(int maxBinaryLiteralLength) {
        this.maxBinaryLiteralLength = maxBinaryLiteralLength;
    }

    public int getMaxCharLiteralLength() {
        return this.maxCharLiteralLength;
    }

    public void setMaxCharLiteralLength(int maxCharLiteralLength) {
        this.maxCharLiteralLength = maxCharLiteralLength;
    }

    public int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    public void setMaxColumnNameLength(int maxColumnNameLength) {
        this.maxColumnNameLength = maxColumnNameLength;
    }

    public int getMaxColumnsInGroupBy() {
        return this.maxColumnsInGroupBy;
    }

    public void setMaxColumnsInGroupBy(int maxColumnsInGroupBy) {
        this.maxColumnsInGroupBy = maxColumnsInGroupBy;
    }

    public int getMaxColumnsInIndex() {
        return this.maxColumnsInIndex;
    }

    public void setMaxColumnsInIndex(int maxColumnsInIndex) {
        this.maxColumnsInIndex = maxColumnsInIndex;
    }

    public int getMaxColumnsInOrderBy() {
        return this.maxColumnsInOrderBy;
    }

    public void setMaxColumnsInOrderBy(int maxColumnsInOrderBy) {
        this.maxColumnsInOrderBy = maxColumnsInOrderBy;
    }

    public int getMaxColumnsInSelect() {
        return this.maxColumnsInSelect;
    }

    public void setMaxColumnsInSelect(int maxColumnsInSelect) {
        this.maxColumnsInSelect = maxColumnsInSelect;
    }

    public int getMaxColumnsInTable() {
        return this.maxColumnsInTable;
    }

    public void setMaxColumnsInTable(int maxColumnsInTable) {
        this.maxColumnsInTable = maxColumnsInTable;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxCursorNameLength() {
        return this.maxCursorNameLength;
    }

    public void setMaxCursorNameLength(int maxCursorNameLength) {
        this.maxCursorNameLength = maxCursorNameLength;
    }

    public int getMaxIndexLength() {
        return this.maxIndexLength;
    }

    public void setMaxIndexLength(int maxIndexLength) {
        this.maxIndexLength = maxIndexLength;
    }

    public int getMaxSchemaNameLength() {
        return this.maxSchemaNameLength;
    }

    public void setMaxSchemaNameLength(int maxSchemaNameLength) {
        this.maxSchemaNameLength = maxSchemaNameLength;
    }

    public int getMaxProcedureNameLength() {
        return this.maxProcedureNameLength;
    }

    public void setMaxProcedureNameLength(int maxProcedureNameLength) {
        this.maxProcedureNameLength = maxProcedureNameLength;
    }

    public int getMaxCatalogNameLength() {
        return this.maxCatalogNameLength;
    }

    public void setMaxCatalogNameLength(int maxCatalogNameLength) {
        this.maxCatalogNameLength = maxCatalogNameLength;
    }

    public int getMaxRowSize() {
        return this.maxRowSize;
    }

    public void setMaxRowSize(int maxRowSize) {
        this.maxRowSize = maxRowSize;
    }

    public boolean isMaxRowSizeIncludeBlobs() {
        return this.maxRowSizeIncludeBlobs;
    }

    public void setMaxRowSizeIncludeBlobs(boolean maxRowSizeIncludeBlobs) {
        this.maxRowSizeIncludeBlobs = maxRowSizeIncludeBlobs;
    }

    public int getMaxStatementLength() {
        return this.maxStatementLength;
    }

    public void setMaxStatementLength(int maxStatementLength) {
        this.maxStatementLength = maxStatementLength;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public void setMaxTableNameLength(int maxTableNameLength) {
        this.maxTableNameLength = maxTableNameLength;
    }

    public int getMaxTablesInSelect() {
        return this.maxTablesInSelect;
    }

    public void setMaxTablesInSelect(int maxTablesInSelect) {
        this.maxTablesInSelect = maxTablesInSelect;
    }

    public int getMaxUserNameLength() {
        return this.maxUserNameLength;
    }

    public void setMaxUserNameLength(int maxUserNameLength) {
        this.maxUserNameLength = maxUserNameLength;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public boolean isSupportsTransactions() {
        return this.supportsTransactions;
    }

    public void setSupportsTransactions(boolean supportsTransactions) {
        this.supportsTransactions = supportsTransactions;
    }

    public boolean isSupportsDataDefinitionAndDataManipulationTransactions() {
        return this.supportsDataDefinitionAndDataManipulationTransactions;
    }

    public void setSupportsDataDefinitionAndDataManipulationTransactions(boolean supportsDataDefinitionAndDataManipulationTransactions) {
        this.supportsDataDefinitionAndDataManipulationTransactions = supportsDataDefinitionAndDataManipulationTransactions;
    }

    public boolean isSupportsDataManipulationTransactionsOnly() {
        return this.supportsDataManipulationTransactionsOnly;
    }

    public void setSupportsDataManipulationTransactionsOnly(boolean supportsDataManipulationTransactionsOnly) {
        this.supportsDataManipulationTransactionsOnly = supportsDataManipulationTransactionsOnly;
    }

    public boolean isDataDefinitionCausesTransactionCommit() {
        return this.dataDefinitionCausesTransactionCommit;
    }

    public void setDataDefinitionCausesTransactionCommit(boolean dataDefinitionCausesTransactionCommit) {
        this.dataDefinitionCausesTransactionCommit = dataDefinitionCausesTransactionCommit;
    }

    public boolean isDataDefinitionIgnoredInTransactions() {
        return this.dataDefinitionIgnoredInTransactions;
    }

    public void setDataDefinitionIgnoredInTransactions(boolean dataDefinitionIgnoredInTransactions) {
        this.dataDefinitionIgnoredInTransactions = dataDefinitionIgnoredInTransactions;
    }

    public boolean isSupportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    public void setSupportsBatchUpdates(boolean supportsBatchUpdates) {
        this.supportsBatchUpdates = supportsBatchUpdates;
    }

    public boolean isSupportsSavepoints() {
        return this.supportsSavepoints;
    }

    public void setSupportsSavepoints(boolean supportsSavepoints) {
        this.supportsSavepoints = supportsSavepoints;
    }

    public boolean isSupportsNamedParameters() {
        return this.supportsNamedParameters;
    }

    public void setSupportsNamedParameters(boolean supportsNamedParameters) {
        this.supportsNamedParameters = supportsNamedParameters;
    }

    public boolean isSupportsMultipleOpenResults() {
        return this.supportsMultipleOpenResults;
    }

    public void setSupportsMultipleOpenResults(boolean supportsMultipleOpenResults) {
        this.supportsMultipleOpenResults = supportsMultipleOpenResults;
    }

    public boolean isSupportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    public void setSupportsGetGeneratedKeys(boolean supportsGetGeneratedKeys) {
        this.supportsGetGeneratedKeys = supportsGetGeneratedKeys;
    }

    public int getGetResultSetHoldability() {
        return this.getResultSetHoldability;
    }

    public void setGetResultSetHoldability(int getResultSetHoldability) {
        this.getResultSetHoldability = getResultSetHoldability;
    }

    public int getGetDatabaseMajorVersion() {
        return this.getDatabaseMajorVersion;
    }

    public void setGetDatabaseMajorVersion(int getDatabaseMajorVersion) {
        this.getDatabaseMajorVersion = getDatabaseMajorVersion;
    }

    public int getGetDatabaseMinorVersion() {
        return this.getDatabaseMinorVersion;
    }

    public void setGetDatabaseMinorVersion(int getDatabaseMinorVersion) {
        this.getDatabaseMinorVersion = getDatabaseMinorVersion;
    }

    public int getGetJDBCMajorVersion() {
        return this.getJDBCMajorVersion;
    }

    public void setGetJDBCMajorVersion(int getJDBCMajorVersion) {
        this.getJDBCMajorVersion = getJDBCMajorVersion;
    }

    public int getGetJDBCMinorVersion() {
        return this.getJDBCMinorVersion;
    }

    public void setGetJDBCMinorVersion(int getJDBCMinorVersion) {
        this.getJDBCMinorVersion = getJDBCMinorVersion;
    }

    public int getGetSQLStateType() {
        return this.getSQLStateType;
    }

    public void setGetSQLStateType(int getSQLStateType) {
        this.getSQLStateType = getSQLStateType;
    }

    public boolean isLocatorsUpdateCopy() {
        return this.locatorsUpdateCopy;
    }

    public void setLocatorsUpdateCopy(boolean locatorsUpdateCopy) {
        this.locatorsUpdateCopy = locatorsUpdateCopy;
    }

    public boolean isSupportsStatementPooling() {
        return this.supportsStatementPooling;
    }

    public void setSupportsStatementPooling(boolean supportsStatementPooling) {
        this.supportsStatementPooling = supportsStatementPooling;
    }

    public boolean isSupportsStoredFunctionsUsingCallSyntax() {
        return this.supportsStoredFunctionsUsingCallSyntax;
    }

    public void setSupportsStoredFunctionsUsingCallSyntax(boolean supportsStoredFunctionsUsingCallSyntax) {
        this.supportsStoredFunctionsUsingCallSyntax = supportsStoredFunctionsUsingCallSyntax;
    }

    public boolean isAutoCommitFailureClosesAllResultSets() {
        return this.autoCommitFailureClosesAllResultSets;
    }

    public void setAutoCommitFailureClosesAllResultSets(boolean autoCommitFailureClosesAllResultSets) {
        this.autoCommitFailureClosesAllResultSets = autoCommitFailureClosesAllResultSets;
    }

    public boolean isGeneratedKeyAlwaysReturned() {
        return this.generatedKeyAlwaysReturned;
    }

    public void setGeneratedKeyAlwaysReturned(boolean generatedKeyAlwaysReturned) {
        this.generatedKeyAlwaysReturned = generatedKeyAlwaysReturned;
    }

    public long getGetMaxLogicalLobSize() {
        return this.getMaxLogicalLobSize;
    }

    public void setGetMaxLogicalLobSize(long getMaxLogicalLobSize) {
        this.getMaxLogicalLobSize = getMaxLogicalLobSize;
    }

    public boolean isSupportsRefCursors() {
        return this.supportsRefCursors;
    }

    public void setSupportsRefCursors(boolean supportsRefCursors) {
        this.supportsRefCursors = supportsRefCursors;
    }

    public List<SchemaMetadata> getSchemas() {
        return this.schemas;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }
}

