/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.api.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.api.metadata.ColumnMetadata;
import org.eclipse.dirigible.database.api.metadata.IndexMetadata;
import org.eclipse.dirigible.databases.helpers.DatabaseMetadataHelper;

public class TableMetadata {
    private String name;
    private String type;
    private String remarks;
    private List<ColumnMetadata> columns;
    private List<IndexMetadata> indices;
    private String kind = "table";

    public TableMetadata(String name, String type, String remarks, Connection connection, String catalogName, String schemaName, boolean deep) throws SQLException {
        this.name = name;
        this.type = type;
        this.remarks = remarks;
        this.columns = new ArrayList<ColumnMetadata>();
        this.indices = new ArrayList<IndexMetadata>();
        if (deep) {
            DatabaseMetadataHelper.iterateTableDefinition(connection, catalogName, schemaName, name, new DatabaseMetadataHelper.ColumnsIteratorCallback(){

                @Override
                public void onColumn(String columnName, String columnType, String columnSize, String isNullable, String isKey) {
                    TableMetadata.this.columns.add(new ColumnMetadata(columnName, columnType, columnSize != null ? Integer.parseInt(columnSize) : 0, Boolean.parseBoolean(isNullable), Boolean.parseBoolean(isKey)));
                }
            }, new DatabaseMetadataHelper.IndicesIteratorCallback(){

                @Override
                public void onIndex(String indexName, String indexType, String columnName, String isNonUnique, String indexQualifier, String ordinalPosition, String sortOrder, String cardinality, String pagesIndex, String filterCondition) {
                    TableMetadata.this.indices.add(new IndexMetadata(indexName, indexType, columnName, Boolean.parseBoolean(isNonUnique), indexQualifier, ordinalPosition, sortOrder, cardinality != null ? Integer.parseInt(cardinality) : 0, pagesIndex != null ? Integer.parseInt(pagesIndex) : 0, filterCondition));
                }
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<ColumnMetadata> getColumns() {
        return this.columns;
    }

    public List<IndexMetadata> getIndices() {
        return this.indices;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }
}

