/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.api.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.api.metadata.FunctionMetadata;
import org.eclipse.dirigible.database.api.metadata.ProcedureMetadata;
import org.eclipse.dirigible.database.api.metadata.TableMetadata;
import org.eclipse.dirigible.databases.helpers.DatabaseMetadataHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaMetadata {
    private static final Logger logger = LoggerFactory.getLogger(SchemaMetadata.class);
    private String name;
    private String kind = "schema";
    private List<TableMetadata> tables;
    private List<ProcedureMetadata> procedures;
    private List<FunctionMetadata> functions;

    public SchemaMetadata(String name, Connection connection, String catalogName, DatabaseMetadataHelper.Filter<String> nameFilter) throws SQLException {
        this.name = name;
        this.tables = DatabaseMetadataHelper.listTables(connection, catalogName, name, nameFilter);
        try {
            this.procedures = DatabaseMetadataHelper.listProcedures(connection, catalogName, name, nameFilter);
        }
        catch (SQLException e) {
            this.procedures = new ArrayList<ProcedureMetadata>();
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.functions = DatabaseMetadataHelper.listFunctions(connection, catalogName, name, nameFilter);
        }
        catch (SQLException e) {
            this.functions = new ArrayList<FunctionMetadata>();
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TableMetadata> getTables() {
        return this.tables;
    }

    public List<ProcedureMetadata> getProcedures() {
        return this.procedures;
    }

    public List<FunctionMetadata> getFunctions() {
        return this.functions;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }
}

