/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.databases.helpers;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseQueryHelper {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseQueryHelper.class);

    private DatabaseQueryHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSingleStatement(Connection connection, String sql, boolean isQuery, RequestExecutionCallback callback) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            if (isQuery) {
                resultSet = preparedStatement.executeQuery();
                callback.queryDone(resultSet);
            } else {
                preparedStatement.executeUpdate();
                callback.updateDone(preparedStatement.getUpdateCount());
            }
        }
        catch (Exception e) {
            logger.error(sql);
            logger.error(e.getMessage(), (Throwable)e);
            callback.error(e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSingleProcedure(Connection connection, String sql, RequestExecutionCallback callback) {
        ResultSet resultSet = null;
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(sql);
            resultSet = callableStatement.executeQuery();
            boolean hasMoreResults = false;
            do {
                callback.queryDone(resultSet);
                resultSet.close();
                hasMoreResults = callableStatement.getMoreResults();
                if (!hasMoreResults) continue;
                resultSet = callableStatement.getResultSet();
            } while (hasMoreResults);
        }
        catch (Exception e) {
            logger.error(sql);
            logger.error(e.getMessage(), (Throwable)e);
            callback.error(e);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeQueryStatement(Connection connection, String sql, ResultSetIteratorCallback callback) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            int columnsCount = resultSet.getMetaData().getColumnCount();
            ArrayList<NavigableMap<String, Object>> table = new ArrayList<NavigableMap<String, Object>>();
            TreeMap<String, Object> row = new TreeMap<String, Object>();
            for (int i = 1; i <= columnsCount; ++i) {
                row.put(resultSet.getMetaData().getColumnName(i), resultSet.getObject(i));
                callback.onRowConstruction(connection, row);
                table.add(row);
            }
            callback.onQueryDone(connection, table);
        }
        catch (Exception e) {
            callback.onError(connection, e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static interface RequestExecutionCallback {
        public void updateDone(int var1);

        public void queryDone(ResultSet var1);

        public void error(Throwable var1);
    }

    public static interface ResultSetIteratorCallback {
        public void onQueryDone(Connection var1, List<NavigableMap<String, Object>> var2);

        public void onRowConstruction(Connection var1, NavigableMap<String, Object> var2);

        public void onError(Connection var1, Throwable var2);
    }

    public static interface Filter<T> {
        public boolean accepts(T var1);
    }

    public static enum Config {
        ShowTableContentScript,
        SchemaFilterScript;

    }
}

