/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.databases.processor.format;

import java.util.List;
import org.eclipse.dirigible.databases.processor.format.ColumnDescriptor;
import org.eclipse.dirigible.databases.processor.format.HeaderFormatter;
import org.eclipse.dirigible.databases.processor.format.ResultSetMonospacedWriter;

public class StringHeaderFormatter
implements HeaderFormatter<String> {
    @Override
    public String write(List<ColumnDescriptor> columnDescriptors) {
        StringBuilder headerSb = new StringBuilder();
        if (columnDescriptors.size() > 0) {
            headerSb.append("|");
        }
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            String lbl = String.format("%-" + columnDescriptor.getDisplaySize() + "s", columnDescriptor.getLabel());
            headerSb.append(lbl);
            headerSb.append("|");
            lbl = "";
        }
        int headerLength = headerSb.length();
        headerSb.append(ResultSetMonospacedWriter.NEWLINE_CHARACTER);
        for (int i = 0; i < headerLength; ++i) {
            headerSb.append("-");
        }
        headerSb.append(ResultSetMonospacedWriter.NEWLINE_CHARACTER);
        return headerSb.toString();
    }
}

