/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.databases.processor.format;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.ClassUtils;
import org.eclipse.dirigible.databases.processor.format.AbstractResultSetWriter;

public class ResultSetCsvWriter
extends AbstractResultSetWriter<String> {
    private boolean limited = true;
    private boolean stringify = true;

    @Override
    public boolean isLimited() {
        return this.limited;
    }

    @Override
    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    @Override
    public boolean isStringified() {
        return this.stringify;
    }

    @Override
    public void setStringified(boolean stringify) {
        this.stringify = stringify;
    }

    @Override
    public String write(ResultSet resultSet) throws SQLException {
        int i;
        StringBuffer names;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<String> records = new ArrayList<String>();
        int count = 0;
        if (resultSet.next()) {
            names = new StringBuffer();
            for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (i > 1) {
                    names.append(",");
                }
                String name = resultSetMetaData.getColumnName(i);
                names.append("\"" + name + "\"");
            }
        } else {
            return "";
        }
        records.add(names.toString());
        count = 0;
        do {
            StringBuffer values = new StringBuffer();
            for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                Object value;
                if (i > 1) {
                    values.append(",");
                }
                if ((value = resultSet.getObject(i)) == null && this.stringify) {
                    value = "[NULL]";
                }
                if (value != null && !ClassUtils.isPrimitiveOrWrapper(value.getClass()) && value.getClass() != String.class && !Date.class.isAssignableFrom(value.getClass()) && this.stringify) {
                    value = "[BINARY]";
                }
                values.append("\"" + value + "\"");
            }
            records.add(values.toString());
        } while ((!this.isLimited() || ++count <= this.getLimit()) && resultSet.next());
        return String.join((CharSequence)"\n", records);
    }
}

