/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.api.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.api.metadata.ParameterColumnMetadata;
import org.eclipse.dirigible.databases.helpers.DatabaseMetadataHelper;

public class ProcedureMetadata {
    private String name;
    private String type;
    private String remarks;
    private List<ParameterColumnMetadata> columns;
    private String kind = "procedure";

    public ProcedureMetadata(String name, String type, String remarks, Connection connection, String catalogName, String schemaName, boolean deep) throws SQLException {
        this.name = name;
        this.type = type;
        this.remarks = remarks;
        this.columns = new ArrayList<ParameterColumnMetadata>();
        if (deep) {
            DatabaseMetadataHelper.iterateProcedureDefinition(connection, catalogName, schemaName, name, new DatabaseMetadataHelper.ProcedureColumnsIteratorCallback(){

                @Override
                public void onProcedureColumn(String name, int kind, String type, int precision, int length, int scale, int radix, boolean nullable, String remarks) {
                    ProcedureMetadata.this.columns.add(new ParameterColumnMetadata(name, kind, type, precision, length, scale, radix, nullable, remarks));
                }
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<ParameterColumnMetadata> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ParameterColumnMetadata> columns) {
        this.columns = columns;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }
}

