/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.dirigible.api.v3.security.UserFacade;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.database.ds.model.DataStructureContentModel;
import org.eclipse.dirigible.database.ds.model.DataStructureDataAppendModel;
import org.eclipse.dirigible.database.ds.model.DataStructureDataDeleteModel;
import org.eclipse.dirigible.database.ds.model.DataStructureDataReplaceModel;
import org.eclipse.dirigible.database.ds.model.DataStructureDataUpdateModel;
import org.eclipse.dirigible.database.ds.model.DataStructureDependencyModel;
import org.eclipse.dirigible.database.ds.model.DataStructureSchemaModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableColumnModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableConstraintForeignKeyModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableModel;
import org.eclipse.dirigible.database.ds.model.DataStructureViewModel;

public class DataStructureModelFactory {
    public static DataStructureTableModel parseTable(String content) {
        DataStructureTableModel result = (DataStructureTableModel)GsonHelper.GSON.fromJson(content, DataStructureTableModel.class);
        result.setHash(DigestUtils.md5Hex((String)content));
        return result;
    }

    public static DataStructureTableModel parseTable(byte[] bytes) {
        DataStructureTableModel result = (DataStructureTableModel)GsonHelper.GSON.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8), DataStructureTableModel.class);
        result.setHash(DigestUtils.md5Hex((byte[])bytes));
        return result;
    }

    public static DataStructureViewModel parseView(String content) {
        DataStructureViewModel result = (DataStructureViewModel)GsonHelper.GSON.fromJson(content, DataStructureViewModel.class);
        result.setHash(DigestUtils.md5Hex((String)content));
        return result;
    }

    public static DataStructureViewModel parseView(byte[] bytes) {
        DataStructureViewModel result = (DataStructureViewModel)GsonHelper.GSON.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8), DataStructureViewModel.class);
        result.setHash(DigestUtils.md5Hex((byte[])bytes));
        return result;
    }

    public static DataStructureDataReplaceModel parseReplace(String location, String content) {
        DataStructureDataReplaceModel result = new DataStructureDataReplaceModel();
        DataStructureModelFactory.setContentModelAttributes(location, content, result, "REPLACE");
        return result;
    }

    public static DataStructureDataAppendModel parseAppend(String location, String content) {
        DataStructureDataAppendModel result = new DataStructureDataAppendModel();
        DataStructureModelFactory.setContentModelAttributes(location, content, result, "APPEND");
        return result;
    }

    public static DataStructureDataDeleteModel parseDelete(String location, String content) {
        DataStructureDataDeleteModel result = new DataStructureDataDeleteModel();
        DataStructureModelFactory.setContentModelAttributes(location, content, result, "DELETE");
        return result;
    }

    public static DataStructureDataUpdateModel parseUpdate(String location, String content) {
        DataStructureDataUpdateModel result = new DataStructureDataUpdateModel();
        DataStructureModelFactory.setContentModelAttributes(location, content, result, "UPDATE");
        return result;
    }

    private static void setContentModelAttributes(String location, String content, DataStructureContentModel dataModel, String type) {
        dataModel.setLocation(location);
        dataModel.setName(FilenameUtils.getBaseName((String)location));
        dataModel.setType(type);
        dataModel.setContent(content);
        dataModel.setCreatedBy(UserFacade.getName());
        dataModel.setCreatedAt(new Timestamp(new Date().getTime()));
        dataModel.setHash(DigestUtils.md5Hex((String)content));
    }

    public static DataStructureSchemaModel parseSchema(String location, String content) {
        String type;
        JsonObject structure;
        int i;
        DataStructureSchemaModel result = new DataStructureSchemaModel();
        DataStructureModelFactory.setContentModelAttributes(location, content, result, "SCHEMA");
        JsonElement root = GsonHelper.PARSER.parse(content);
        JsonArray structures = root.getAsJsonObject().get("schema").getAsJsonObject().get("structures").getAsJsonArray();
        for (i = 0; i < structures.size(); ++i) {
            structure = structures.get(i).getAsJsonObject();
            type = structure.get("type").getAsString();
            if ("table".equalsIgnoreCase(type)) {
                DataStructureTableModel table = new DataStructureTableModel();
                DataStructureModelFactory.setTableAttributes(location, result, structure, type, table);
                result.getTables().add(table);
                continue;
            }
            if ("view".equalsIgnoreCase(type)) {
                DataStructureViewModel view = new DataStructureViewModel();
                DataStructureModelFactory.setViewAttributes(location, result, structure, type, view);
                result.getViews().add(view);
                continue;
            }
            if ("foreignKey".equalsIgnoreCase(type)) continue;
            throw new IllegalArgumentException(MessageFormat.format("Unknown data structure type [{0}] loaded from schema [{1}]", type, location));
        }
        block1: for (i = 0; i < structures.size(); ++i) {
            structure = structures.get(i).getAsJsonObject();
            type = structure.get("type").getAsString();
            if (!"foreignKey".equals(type)) continue;
            DataStructureTableConstraintForeignKeyModel foreignKey = new DataStructureTableConstraintForeignKeyModel();
            foreignKey.setName(structure.get("name").getAsString());
            foreignKey.setColumns(structure.get("columns").getAsString().split(","));
            foreignKey.setReferencedTable(structure.get("referencedTable").getAsString());
            foreignKey.setReferencedColumns(structure.get("referencedColumns").getAsString().split(","));
            String tableName = structure.get("table").getAsString();
            for (DataStructureTableModel table : result.getTables()) {
                if (!table.getName().equals(tableName)) continue;
                ArrayList<DataStructureTableConstraintForeignKeyModel> list = new ArrayList<DataStructureTableConstraintForeignKeyModel>();
                if (table.getConstraints().getForeignKeys() != null) {
                    list.addAll(Arrays.asList(table.getConstraints().getForeignKeys()));
                }
                list.add(foreignKey);
                table.getConstraints().setForeignKeys(list.toArray(new DataStructureTableConstraintForeignKeyModel[0]));
                DataStructureDependencyModel dependencyModel = new DataStructureDependencyModel(foreignKey.getReferencedTable(), "TABLE");
                table.getDependencies().add(dependencyModel);
                continue block1;
            }
        }
        return result;
    }

    private static void setViewAttributes(String location, DataStructureSchemaModel result, JsonObject structure, String type, DataStructureViewModel view) {
        view.setLocation(location);
        view.setName(structure.get("name").getAsString());
        view.setType(type);
        view.setQuery(structure.get("columns").getAsJsonArray().get(0).getAsJsonObject().get("query").getAsString());
        view.setCreatedAt(result.getCreatedAt());
        view.setCreatedBy(result.getCreatedBy());
        view.setHash(result.getHash());
    }

    private static void setTableAttributes(String location, DataStructureSchemaModel result, JsonObject structure, String type, DataStructureTableModel table) {
        table.setLocation(location);
        table.setName(structure.get("name").getAsString());
        table.setType(type);
        table.setCreatedAt(result.getCreatedAt());
        table.setCreatedBy(result.getCreatedBy());
        table.setHash(result.getHash());
        JsonElement columnElement = structure.get("columns");
        if (columnElement.isJsonObject()) {
            JsonObject column = columnElement.getAsJsonObject();
            DataStructureTableColumnModel columnModel = new DataStructureTableColumnModel();
            DataStructureModelFactory.setColumnAttributes(column, columnModel);
            table.getColumns().add(columnModel);
        } else if (columnElement.isJsonArray()) {
            JsonArray columns = columnElement.getAsJsonArray();
            for (int j = 0; j < columns.size(); ++j) {
                JsonObject column = columns.get(j).getAsJsonObject();
                DataStructureTableColumnModel columnModel = new DataStructureTableColumnModel();
                DataStructureModelFactory.setColumnAttributes(column, columnModel);
                table.getColumns().add(columnModel);
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Error in parsing columns of table [{0}] in schema [{1}]", table.getName(), location));
        }
    }

    private static void setColumnAttributes(JsonObject column, DataStructureTableColumnModel columnModel) {
        columnModel.setName(column.get("name") != null && !column.get("name").isJsonNull() ? column.get("name").getAsString() : "unknown");
        columnModel.setType(column.get("type") != null && !column.get("type").isJsonNull() ? column.get("type").getAsString() : "unknown");
        columnModel.setLength(column.get("length") != null && !column.get("length").isJsonNull() ? column.get("length").getAsString() : null);
        columnModel.setPrimaryKey(column.get("primaryKey") != null && !column.get("primaryKey").isJsonNull() ? column.get("primaryKey").getAsBoolean() : false);
        columnModel.setUnique(column.get("unique") != null && !column.get("unique").isJsonNull() ? column.get("unique").getAsBoolean() : false);
        columnModel.setNullable(column.get("nullable") != null && !column.get("nullable").isJsonNull() ? column.get("nullable").getAsBoolean() : false);
        columnModel.setDefaultValue(column.get("defaultValue") != null && !column.get("defaultValue").isJsonNull() ? column.get("defaultValue").getAsString() : null);
        columnModel.setPrecision(column.get("precision") != null && !column.get("precision").isJsonNull() ? column.get("precision").getAsString() : null);
        columnModel.setScale(column.get("scale") != null && !column.get("scale").isJsonNull() ? column.get("scale").getAsString() : null);
    }
}

