/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.database.ds.model.DataStructureDependencyModel;
import org.eclipse.dirigible.database.ds.model.DataStructureModel;
import org.eclipse.dirigible.database.ds.model.DataStructureModelException;

public class DataStructureTopologicalSorter {
    public static void sort(Map<String, DataStructureModel> input, List<String> output, List<String> external) throws DataStructureModelException {
        ArrayList<String> processing = new ArrayList<String>();
        for (Map.Entry<String, DataStructureModel> entry : input.entrySet()) {
            DataStructureModel dataStructureModel = entry.getValue();
            DataStructureTopologicalSorter.followDependencies(input, output, external, processing, dataStructureModel);
            String name = dataStructureModel.getName();
            if (output.contains(name)) continue;
            output.add(name);
        }
    }

    protected static void followDependencies(Map<String, DataStructureModel> input, List<String> output, List<String> external, List<String> processing, DataStructureModel dataStructureModel) throws DataStructureModelException {
        processing.add(dataStructureModel.getName());
        List<DataStructureDependencyModel> dependencies = dataStructureModel.getDependencies();
        for (DataStructureDependencyModel dependencyModel : dependencies) {
            String dependencyName = dependencyModel.getName();
            if (input.containsKey(dependencyName)) {
                if (processing.contains(dependencyName)) {
                    throw new DataStructureModelException(String.format("Cyclic dependency %s in %s", dataStructureModel.getName(), dependencyName));
                }
                DataStructureModel dependentModel = input.get(dependencyName);
                if (output.contains(dependencyName)) continue;
                DataStructureTopologicalSorter.followDependencies(input, output, external, processing, dependentModel);
                output.add(dependencyName);
                continue;
            }
            external.add(dependencyName);
        }
        processing.remove(dataStructureModel.getName());
    }
}

