/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model.processors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.dirigible.database.ds.model.DataStructureTableColumnModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableConstraintCheckModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableConstraintForeignKeyModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableConstraintModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableModel;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCreateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TableCreateProcessor.class);

    public static void execute(Connection connection, DataStructureTableModel tableModel) throws SQLException {
        logger.info("Processing Create Table: " + tableModel.getName());
        CreateTableBuilder createTableBuilder = SqlFactory.getNative((Connection)connection).create().table(tableModel.getName());
        List<DataStructureTableColumnModel> columns = tableModel.getColumns();
        for (DataStructureTableColumnModel columnModel : columns) {
            String name = columnModel.getName();
            DataType dataType = DataType.valueOf((String)columnModel.getType());
            String length = columnModel.getLength();
            boolean isNullable = columnModel.isNullable();
            boolean isPrimaryKey = columnModel.isPrimaryKey();
            boolean isUnique = columnModel.isUnique();
            String defaultValue = columnModel.getDefaultValue();
            String precision = columnModel.getPrecision();
            String scale = columnModel.getScale();
            String args = "";
            if (length != null) {
                if (dataType.equals((Object)DataType.VARCHAR) || dataType.equals((Object)DataType.CHAR)) {
                    args = "(" + length + ")";
                }
            } else if (precision != null && scale != null && dataType.equals((Object)DataType.DECIMAL)) {
                args = "(" + precision + "," + scale + ")";
            }
            if (defaultValue != null) {
                if ("".equals(defaultValue)) {
                    if (dataType.equals((Object)DataType.VARCHAR) || dataType.equals((Object)DataType.CHAR)) {
                        args = args + " DEFAULT '" + defaultValue + "' ";
                    }
                } else {
                    args = args + " DEFAULT " + defaultValue + " ";
                }
            }
            createTableBuilder.column(name, dataType, Boolean.valueOf(isPrimaryKey), Boolean.valueOf(isNullable), Boolean.valueOf(isUnique), new String[]{args});
        }
        if (tableModel.getConstraints() != null) {
            if (tableModel.getConstraints().getPrimaryKey() != null) {
                createTableBuilder.primaryKey(tableModel.getConstraints().getPrimaryKey().getColumns());
            }
            if (tableModel.getConstraints().getForeignKeys() != null) {
                for (DataStructureTableConstraintModel dataStructureTableConstraintModel : tableModel.getConstraints().getForeignKeys()) {
                    createTableBuilder.foreignKey(dataStructureTableConstraintModel.getName(), dataStructureTableConstraintModel.getColumns(), ((DataStructureTableConstraintForeignKeyModel)dataStructureTableConstraintModel).getReferencedTable(), ((DataStructureTableConstraintForeignKeyModel)dataStructureTableConstraintModel).getReferencedColumns());
                }
            }
            if (tableModel.getConstraints().getUniqueIndices() != null) {
                for (DataStructureTableConstraintModel dataStructureTableConstraintModel : tableModel.getConstraints().getUniqueIndices()) {
                    createTableBuilder.unique(dataStructureTableConstraintModel.getName(), dataStructureTableConstraintModel.getColumns());
                }
            }
            if (tableModel.getConstraints().getChecks() != null) {
                for (DataStructureTableConstraintModel dataStructureTableConstraintModel : tableModel.getConstraints().getChecks()) {
                    createTableBuilder.check(dataStructureTableConstraintModel.getName(), ((DataStructureTableConstraintCheckModel)dataStructureTableConstraintModel).getExpression());
                }
            }
        }
        String sql = createTableBuilder.build();
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            logger.info(sql);
            statement.executeUpdate();
        }
    }
}

