/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model.transfer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.eclipse.dirigible.database.ds.model.transfer.TableColumn;
import org.eclipse.dirigible.database.ds.model.transfer.TableMetadataHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableExporter {
    private static final String SELECT_FROM = "SELECT * FROM ";
    private static final String THERE_IS_NO_DATA_IN_TABLE = "There is no data in table ";
    private static final String COULD_NOT_RETRIEVE_TABLE_DATA = "Could not retrieve table data reason: Table name is null";
    private static final String ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_TABLE = "Error on loading table columns from the Database for Table: ";
    public static final String DATA_DELIMETER = "|";
    private String tableName;
    private String tableType;
    private TableColumn[] tableColumns;
    private static final Logger logger = LoggerFactory.getLogger(TableExporter.class);
    private DataSource dataSource;

    public TableExporter(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableData() {
        String data = "";
        if (this.getTableName() == null) {
            data = COULD_NOT_RETRIEVE_TABLE_DATA;
            logger.error(COULD_NOT_RETRIEVE_TABLE_DATA);
            return data;
        }
        try (Connection connection = null;){
            connection = this.dataSource.getConnection();
            List<TableColumn> availableTableColumns = TableMetadataHelper.getColumns(connection, this.getTableName());
            this.setTableColumns(availableTableColumns.toArray(new TableColumn[0]));
            data = this.getDataForTable();
        }
        catch (Exception e) {
            logger.error(ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_TABLE + this.getTableName(), (Throwable)e);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDataForTable() {
        String sql = null;
        String result = null;
        Statement statement = null;
        ResultSet resultSet = null;
        StringBuilder sb = new StringBuilder();
        String tableName = this.getTableName();
        TableColumn[] columns = this.getTableColumns();
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            sql = SELECT_FROM + tableName;
            resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                for (TableColumn column : columns) {
                    sb.append(resultSet.getString(column.getName()));
                    sb.append(DATA_DELIMETER);
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("\n");
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException se) {
            logger.error(se.getMessage(), (Throwable)se);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        result = sb.toString();
        if (result.equalsIgnoreCase("")) {
            return THERE_IS_NO_DATA_IN_TABLE + tableName;
        }
        return result;
    }

    private boolean exists(List<TableColumn> availableTableColumns, TableColumn tableColumn) {
        if (this.getTableName() == null) {
            return false;
        }
        for (TableColumn tableColumn2 : availableTableColumns) {
            TableColumn tableColumnX = tableColumn2;
            if (!tableColumnX.getName().equals(tableColumn.getName())) continue;
            tableColumnX.setType(tableColumn.getType());
            return true;
        }
        return false;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public TableColumn[] getTableColumns() {
        return this.tableColumns;
    }

    public void setTableColumns(TableColumn[] tableColumns) {
        this.tableColumns = tableColumns;
    }
}

