/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model.processors;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.database.ds.model.DataStructureTableColumnModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableModel;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.DataTypeUtils;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.table.AlterTableBuilder;
import org.eclipse.dirigible.databases.helpers.DatabaseMetadataHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableAlterProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TableAlterProcessor.class);
    private static final String INCOMPATIBLE_CHANGE_OF_TABLE = "Incompatible change of table [%s] by adding a column [%s] which is [%s]";

    public static void execute(Connection connection, DataStructureTableModel tableModel) throws SQLException {
        boolean caseSensitive = Boolean.parseBoolean(Configuration.get((String)"DIRIGIBLE_DATABASE_NAMES_CASE_SENSITIVE", (String)"false"));
        Object tableName = tableModel.getName();
        if (caseSensitive) {
            tableName = "\"" + (String)tableName + "\"";
        }
        logger.info("Processing Alter Table: " + (String)tableName);
        HashMap<String, String> columnDefinitions = new HashMap<String, String>();
        DatabaseMetaData dmd = connection.getMetaData();
        ResultSet rsColumns = dmd.getColumns(null, null, DatabaseMetadataHelper.normalizeTableName((String)tableName), null);
        while (rsColumns.next()) {
            String typeName = DataTypeUtils.getDatabaseTypeName((Integer)rsColumns.getInt(5));
            columnDefinitions.put(rsColumns.getString(4).toUpperCase(), typeName);
        }
        ArrayList<String> modelColumnNames = new ArrayList<String>();
        for (DataStructureTableColumnModel columnModel : tableModel.getColumns()) {
            Object name = columnModel.getName();
            if (caseSensitive) {
                name = "\"" + (String)name + "\"";
            }
            DataType type = DataType.valueOf((String)columnModel.getType());
            String length = columnModel.getLength();
            boolean isNullable = columnModel.isNullable();
            boolean isPrimaryKey = columnModel.isPrimaryKey();
            boolean isUnique = columnModel.isUnique();
            String defaultValue = columnModel.getDefaultValue();
            String precision = columnModel.getPrecision();
            String scale = columnModel.getScale();
            Object args = "";
            if (length != null) {
                if (type.equals((Object)DataType.VARCHAR) || type.equals((Object)DataType.CHAR) || type.equals((Object)DataType.NVARCHAR)) {
                    args = "(" + length + ")";
                }
            } else if (precision != null && scale != null && type.equals((Object)DataType.DECIMAL)) {
                args = "(" + precision + "," + scale + ")";
            }
            if (defaultValue != null) {
                if ("".equals(defaultValue)) {
                    if (type.equals((Object)DataType.VARCHAR) || type.equals((Object)DataType.CHAR) || type.equals((Object)DataType.NVARCHAR)) {
                        args = (String)args + " DEFAULT '" + defaultValue + "' ";
                    }
                } else {
                    args = (String)args + " DEFAULT " + defaultValue + " ";
                }
            }
            modelColumnNames.add(((String)name).toUpperCase());
            if (!columnDefinitions.containsKey(((String)name).toUpperCase())) {
                AlterTableBuilder alterTableBuilder = SqlFactory.getNative((Connection)connection).alter().table((String)tableName);
                alterTableBuilder.add().column((String)name, type, Boolean.valueOf(isPrimaryKey), Boolean.valueOf(isNullable), Boolean.valueOf(isUnique), new String[]{args});
                if (!isNullable) {
                    throw new SQLException(String.format(INCOMPATIBLE_CHANGE_OF_TABLE, tableName, name, "NOT NULL"));
                }
                if (isPrimaryKey) {
                    throw new SQLException(String.format(INCOMPATIBLE_CHANGE_OF_TABLE, tableName, name, "PRIMARY KEY"));
                }
                TableAlterProcessor.executeAlterBuilder(connection, alterTableBuilder);
                continue;
            }
            if (((String)columnDefinitions.get(((String)name).toUpperCase())).equals(type.toString())) continue;
            throw new SQLException(String.format(INCOMPATIBLE_CHANGE_OF_TABLE, tableName, name, "of type " + (String)columnDefinitions.get(name) + " to be changed to" + type));
        }
        for (Object columnName : columnDefinitions.keySet()) {
            if (modelColumnNames.contains(((String)columnName).toUpperCase())) continue;
            AlterTableBuilder alterTableBuilder = SqlFactory.getNative((Connection)connection).alter().table((String)tableName);
            if (caseSensitive) {
                columnName = "\"" + (String)columnName + "\"";
            }
            alterTableBuilder.drop().column((String)columnName, DataType.BOOLEAN);
            TableAlterProcessor.executeAlterBuilder(connection, alterTableBuilder);
        }
    }

    private static void executeAlterBuilder(Connection connection, AlterTableBuilder alterTableBuilder) throws SQLException {
        String sql = alterTableBuilder.build();
        logger.info(sql);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
    }
}

