/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model.processors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.database.ds.model.DataStructureTableColumnModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableConstraintCheckModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableConstraintForeignKeyModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableConstraintUniqueModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableModel;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCreateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TableCreateProcessor.class);

    public static void execute(Connection connection, DataStructureTableModel tableModel) throws SQLException {
        TableCreateProcessor.execute(connection, tableModel, false);
    }

    public static void execute(Connection connection, DataStructureTableModel tableModel, boolean skipForeignKeys) throws SQLException {
        boolean caseSensitive = Boolean.parseBoolean(Configuration.get((String)"DIRIGIBLE_DATABASE_NAMES_CASE_SENSITIVE", (String)"false"));
        Object tableName = tableModel.getName();
        if (caseSensitive) {
            tableName = "\"" + (String)tableName + "\"";
        }
        logger.info("Processing Create Table: " + (String)tableName);
        CreateTableBuilder createTableBuilder = SqlFactory.getNative((Connection)connection).create().table((String)tableName);
        List<DataStructureTableColumnModel> columns = tableModel.getColumns();
        for (DataStructureTableColumnModel columnModel : columns) {
            String[] name = columnModel.getName();
            if (caseSensitive) {
                name = "\"" + (String)name + "\"";
            }
            DataType type = DataType.valueOf((String)columnModel.getType());
            String length = columnModel.getLength();
            boolean isNullable = columnModel.isNullable();
            boolean isPrimaryKey = columnModel.isPrimaryKey();
            boolean isUnique = columnModel.isUnique();
            String defaultValue = columnModel.getDefaultValue();
            String precision = columnModel.getPrecision();
            String scale = columnModel.getScale();
            Object args = "";
            if (length != null) {
                if (type.equals((Object)DataType.VARCHAR) || type.equals((Object)DataType.CHAR) || type.equals((Object)DataType.NVARCHAR)) {
                    args = "(" + length + ")";
                }
            } else if (precision != null && scale != null && type.equals((Object)DataType.DECIMAL)) {
                args = "(" + precision + "," + scale + ")";
            }
            if (defaultValue != null) {
                if ("".equals(defaultValue)) {
                    if (type.equals((Object)DataType.VARCHAR) || type.equals((Object)DataType.CHAR) || type.equals((Object)DataType.NVARCHAR)) {
                        args = (String)args + " DEFAULT '" + defaultValue + "' ";
                    }
                } else {
                    args = (String)args + " DEFAULT " + defaultValue + " ";
                }
            }
            createTableBuilder.column((String)name, type, Boolean.valueOf(isPrimaryKey), Boolean.valueOf(isNullable), Boolean.valueOf(isUnique), new String[]{args});
        }
        if (tableModel.getConstraints() != null) {
            if (tableModel.getConstraints().getPrimaryKey() != null) {
                String[] primaryKeyColumns = new String[tableModel.getConstraints().getPrimaryKey().getColumns().length];
                int i = 0;
                for (String column : tableModel.getConstraints().getPrimaryKey().getColumns()) {
                    primaryKeyColumns[i++] = caseSensitive ? "\"" + column + "\"" : column;
                }
                createTableBuilder.primaryKey(primaryKeyColumns);
            }
            if (!skipForeignKeys && tableModel.getConstraints().getForeignKeys() != null && !tableModel.getConstraints().getForeignKeys().isEmpty()) {
                for (DataStructureTableConstraintForeignKeyModel foreignKey : tableModel.getConstraints().getForeignKeys()) {
                    Object foreignKeyName = foreignKey.getName();
                    if (caseSensitive) {
                        foreignKeyName = "\"" + (String)foreignKeyName + "\"";
                    }
                    String[] foreignKeyColumns = new String[foreignKey.getColumns().length];
                    int i = 0;
                    for (String column : foreignKey.getColumns()) {
                        foreignKeyColumns[i++] = caseSensitive ? "\"" + column + "\"" : column;
                    }
                    Object foreignKeyReferencedTable = foreignKey.getReferencedTable();
                    if (caseSensitive) {
                        foreignKeyReferencedTable = "\"" + (String)foreignKeyReferencedTable + "\"";
                    }
                    String[] foreignKeyReferencedColumns = new String[foreignKey.getReferencedColumns().length];
                    i = 0;
                    for (String column : foreignKey.getReferencedColumns()) {
                        foreignKeyReferencedColumns[i++] = caseSensitive ? "\"" + column + "\"" : column;
                    }
                    createTableBuilder.foreignKey((String)foreignKeyName, foreignKeyColumns, (String)foreignKeyReferencedTable, foreignKeyReferencedColumns);
                }
            }
            if (tableModel.getConstraints().getUniqueIndices() != null) {
                for (DataStructureTableConstraintUniqueModel uniqueIndex : tableModel.getConstraints().getUniqueIndices()) {
                    Object uniqueIndexName = uniqueIndex.getName();
                    if (caseSensitive) {
                        uniqueIndexName = "\"" + (String)uniqueIndexName + "\"";
                    }
                    String[] uniqueIndexColumns = new String[uniqueIndex.getColumns().length];
                    int i = 0;
                    for (String column : uniqueIndex.getColumns()) {
                        uniqueIndexColumns[i++] = caseSensitive ? "\"" + column + "\"" : column;
                    }
                    createTableBuilder.unique((String)uniqueIndexName, uniqueIndexColumns);
                }
            }
            if (tableModel.getConstraints().getChecks() != null) {
                for (DataStructureTableConstraintCheckModel check : tableModel.getConstraints().getChecks()) {
                    Object checkName = check.getName();
                    if (caseSensitive) {
                        checkName = "\"" + (String)checkName + "\"";
                    }
                    createTableBuilder.check((String)checkName, check.getExpression());
                }
            }
        }
        String sql = createTableBuilder.build();
        logger.info(sql);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
    }
}

