/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model.processors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.database.ds.model.DataStructureTableConstraintForeignKeyModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableModel;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDropProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TableDropProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Connection connection, DataStructureTableModel tableModel) throws SQLException {
        boolean caseSensitive = Boolean.parseBoolean(Configuration.get((String)"DIRIGIBLE_DATABASE_NAMES_CASE_SENSITIVE", (String)"false"));
        Object tableName = tableModel.getName();
        if (caseSensitive) {
            tableName = "\"" + (String)tableName + "\"";
        }
        logger.info("Processing Drop Table: " + (String)tableName);
        if (SqlFactory.getNative((Connection)connection).exists(connection, (String)tableName)) {
            String sql = SqlFactory.getNative((Connection)connection).select().column("COUNT(*)").from((String)tableName).build();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                int count;
                logger.info(sql);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                    logger.error(MessageFormat.format("Drop operation for the non empty Table [{0}] will not be executed. Delete all the records in the table first.", tableName));
                    return;
                }
            }
            if (tableModel.getConstraints().getForeignKeys() != null && !tableModel.getConstraints().getForeignKeys().isEmpty()) {
                for (DataStructureTableConstraintForeignKeyModel foreignKeyModel : tableModel.getConstraints().getForeignKeys()) {
                    sql = SqlFactory.getNative((Connection)connection).drop().constraint(foreignKeyModel.getName()).fromTable((String)tableName).build();
                    TableDropProcessor.executeUpdate(connection, sql);
                }
            }
            sql = SqlFactory.getNative((Connection)connection).drop().table((String)tableName).build();
            TableDropProcessor.executeUpdate(connection, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeUpdate(Connection connection, String sql) throws SQLException {
        logger.info(sql);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
    }
}

