/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model.processors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.database.ds.model.DataStructureTableConstraintForeignKeyModel;
import org.eclipse.dirigible.database.ds.model.DataStructureTableModel;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.table.AlterTableBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableForeignKeysCreateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TableForeignKeysCreateProcessor.class);

    public static void execute(Connection connection, DataStructureTableModel tableModel) throws SQLException {
        boolean caseSensitive = Boolean.parseBoolean(Configuration.get((String)"DIRIGIBLE_DATABASE_NAMES_CASE_SENSITIVE", (String)"false"));
        Object tableName = tableModel.getName();
        if (caseSensitive) {
            tableName = "\"" + (String)tableName + "\"";
        }
        if (tableModel.getConstraints() != null && tableModel.getConstraints().getForeignKeys() != null && !tableModel.getConstraints().getForeignKeys().isEmpty()) {
            logger.info("Processing Alter Table Create Foreign Keys Table: " + (String)tableName);
            AlterTableBuilder alterTableBuilder = SqlFactory.getNative((Connection)connection).alter().table((String)tableName);
            for (DataStructureTableConstraintForeignKeyModel foreignKey : tableModel.getConstraints().getForeignKeys()) {
                Object foreignKeyName = foreignKey.getName();
                if (caseSensitive) {
                    foreignKeyName = "\"" + (String)foreignKeyName + "\"";
                }
                alterTableBuilder.add().foreignKey((String)foreignKeyName, foreignKey.getColumns(), foreignKey.getReferencedTable(), foreignKey.getReferencedColumns());
            }
            String sql = alterTableBuilder.build();
            logger.info(sql);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.executeUpdate();
            }
        }
    }
}

