/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model.processors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.database.ds.model.DataStructureViewModel;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewDropProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ViewDropProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Connection connection, DataStructureViewModel viewModel) throws SQLException {
        boolean caseSensitive = Boolean.parseBoolean(Configuration.get((String)"DIRIGIBLE_DATABASE_NAMES_CASE_SENSITIVE", (String)"false"));
        Object viewName = viewModel.getName();
        if (caseSensitive) {
            viewName = "\"" + (String)viewName + "\"";
        }
        logger.info("Processing Drop View: " + (String)viewName);
        if (SqlFactory.getNative((Connection)connection).exists(connection, (String)viewName)) {
            String sql = SqlFactory.getNative((Connection)connection).drop().view((String)viewName).build();
            logger.info(sql);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.executeUpdate();
            }
        }
    }
}

