/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model.transfer;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import javax.sql.DataSource;
import org.eclipse.dirigible.commons.api.helpers.DataStructuresUtils;
import org.eclipse.dirigible.commons.api.helpers.DateTimeUtils;
import org.eclipse.dirigible.database.ds.model.transfer.TableColumn;
import org.eclipse.dirigible.database.ds.model.transfer.TableDataReader;
import org.eclipse.dirigible.database.ds.model.transfer.TableMetadataHelper;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.records.InsertBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableImporter {
    private static final Logger logger = LoggerFactory.getLogger(TableImporter.class);
    private static final int BATCH_SIZE = 500;
    private byte[] content;
    private String tableName;
    private DataSource dataSource;

    public TableImporter(DataSource dataSource, byte[] content, String tableName) {
        this.content = content;
        this.tableName = DataStructuresUtils.getCaseSensitiveTableName((String)tableName);
        this.dataSource = dataSource;
    }

    public void insert() throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection();
            List<String[]> records = TableDataReader.readRecords(new ByteArrayInputStream(this.content));
            this.insertRecords(connection, records, this.tableName);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void insertRecords(Connection connection, List<String[]> records, String tableName) throws SQLException, ParseException {
        logger.debug("Start importing data for the table: {} ...", (Object)tableName);
        InsertBuilder insertBuilder = new InsertBuilder(SqlFactory.deriveDialect((Connection)connection));
        insertBuilder.into(tableName);
        List<TableColumn> availableTableColumns = TableMetadataHelper.getColumns(connection, tableName);
        for (int i = 0; i < availableTableColumns.size(); ++i) {
            String columnName = availableTableColumns.get(i).getName();
            insertBuilder.column("\"" + columnName + "\"").value("?");
        }
        PreparedStatement insertStatement = connection.prepareStatement(insertBuilder.build());
        int recordsInBatch = 0;
        int rn = 0;
        for (String[] record : records) {
            ++rn;
            if (record.length > availableTableColumns.size()) {
                logger.error("Columns count in the provided data record is bigger than the available columns number in the target table: {}. Skipped record number: {}", (Object)tableName, (Object)rn);
            }
            block15: for (int i = 0; i < record.length; ++i) {
                TableColumn tableColumn = availableTableColumns.get(i);
                switch (tableColumn.getType()) {
                    case 4: {
                        insertStatement.setInt(i + 1, Integer.parseInt(record[i]));
                        continue block15;
                    }
                    case -5: {
                        insertStatement.setLong(i + 1, Long.parseLong(record[i]));
                        continue block15;
                    }
                    case 5: {
                        insertStatement.setShort(i + 1, Short.parseShort(record[i]));
                        continue block15;
                    }
                    case -6: {
                        insertStatement.setByte(i + 1, Byte.parseByte(record[i]));
                        continue block15;
                    }
                    case -7: 
                    case 16: {
                        insertStatement.setBoolean(i + 1, Boolean.parseBoolean(record[i]));
                        continue block15;
                    }
                    case 8: {
                        insertStatement.setDouble(i + 1, Double.parseDouble(record[i]));
                        continue block15;
                    }
                    case 6: 
                    case 7: {
                        insertStatement.setFloat(i + 1, Float.parseFloat(record[i]));
                        continue block15;
                    }
                    case 3: {
                        insertStatement.setBigDecimal(i + 1, new BigDecimal(record[i]));
                        continue block15;
                    }
                    case 91: {
                        insertStatement.setDate(i + 1, DateTimeUtils.parseDate((String)record[i]));
                        continue block15;
                    }
                    case 92: {
                        insertStatement.setTime(i + 1, DateTimeUtils.parseTime((String)record[i]));
                        continue block15;
                    }
                    case 93: {
                        insertStatement.setTimestamp(i + 1, DateTimeUtils.parseDateTime((String)record[i]));
                        continue block15;
                    }
                    default: {
                        insertStatement.setString(i + 1, record[i]);
                    }
                }
            }
            insertStatement.addBatch();
            if (++recordsInBatch != 500) continue;
            insertStatement.executeBatch();
            recordsInBatch = 0;
        }
        if (recordsInBatch != 0) {
            insertStatement.executeBatch();
        }
        logger.debug("Done importing data for the table: {}, records: {}", (Object)tableName, (Object)rn);
    }

    private void closeConnection(Connection con) throws SQLException {
        if (con != null) {
            con.close();
        }
    }

    private Connection getConnection() throws Exception {
        Connection con = this.dataSource.getConnection();
        return con;
    }
}

