/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.ds.model.transfer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.ds.model.transfer.TableColumn;
import org.eclipse.dirigible.databases.helpers.DatabaseMetadataHelper;

public class TableMetadataHelper {
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String COLUMN_NAME = "COLUMN_NAME";

    public static List<TableColumn> getColumns(Connection connection, String name) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        if (name == null) {
            throw new SQLException("Error on getting columns of table: null");
        }
        ResultSet columns = meta.getColumns(null, null, DatabaseMetadataHelper.normalizeTableName((String)name), null);
        if (columns.next()) {
            return TableMetadataHelper.populateColumns(meta.getColumns(null, null, DatabaseMetadataHelper.normalizeTableName((String)name), null));
        }
        columns = meta.getColumns(null, null, name.toLowerCase(), null);
        if (columns.next()) {
            return TableMetadataHelper.populateColumns(meta.getColumns(null, null, DatabaseMetadataHelper.normalizeTableName((String)name).toLowerCase(), null));
        }
        columns = meta.getColumns(null, null, DatabaseMetadataHelper.normalizeTableName((String)name).toUpperCase(), null);
        return TableMetadataHelper.populateColumns(columns);
    }

    private static List<TableColumn> populateColumns(ResultSet columns) throws SQLException {
        ArrayList<TableColumn> availableTableColumns = new ArrayList<TableColumn>();
        while (columns.next()) {
            String columnName = columns.getString(COLUMN_NAME);
            int columnType = columns.getInt(DATA_TYPE);
            TableColumn tableColumn = new TableColumn(columnName, columnType, false, true);
            availableTableColumns.add(tableColumn);
        }
        return availableTableColumns;
    }

    public static ResultSet getPrimaryKeys(Connection connection, String name) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        if (name == null) {
            throw new SQLException("Error on getting primary keys of table: null");
        }
        ResultSet columns = meta.getPrimaryKeys(null, null, DatabaseMetadataHelper.normalizeTableName((String)name));
        if (columns.next()) {
            return meta.getPrimaryKeys(null, null, DatabaseMetadataHelper.normalizeTableName((String)name));
        }
        columns = meta.getPrimaryKeys(null, null, DatabaseMetadataHelper.normalizeTableName((String)name).toLowerCase());
        if (columns.next()) {
            return meta.getPrimaryKeys(null, null, DatabaseMetadataHelper.normalizeTableName((String)name).toLowerCase());
        }
        columns = meta.getPrimaryKeys(null, null, DatabaseMetadataHelper.normalizeTableName((String)name).toUpperCase());
        return columns;
    }
}

