/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableColumnModel;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.DataTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceAnnotationsParser {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceAnnotationsParser.class);
    private static final Map<Class, PersistenceTableModel> MODELS_CACHE = Collections.synchronizedMap(new HashMap());

    public PersistenceTableModel parsePojo(Object pojo) throws PersistenceException {
        Class<?> clazz = pojo.getClass();
        PersistenceTableModel persistenceTableModel = this.parseTable(clazz);
        return persistenceTableModel;
    }

    public PersistenceTableModel parsePojo(Class<? extends Object> clazz) throws PersistenceException {
        PersistenceTableModel persistenceTableModel = this.parseTable(clazz);
        return persistenceTableModel;
    }

    private PersistenceTableModel parseTable(Class<? extends Object> clazz) {
        PersistenceTableModel persistenceTableModel = MODELS_CACHE.get(clazz);
        if (persistenceTableModel != null) {
            return persistenceTableModel;
        }
        Annotation annotation = this.getTableAnnotation(clazz);
        if (annotation == null) {
            throw new PersistenceException(MessageFormat.format("No Table annotation found in Class {0}", clazz));
        }
        Table table = (Table)annotation;
        persistenceTableModel = new PersistenceTableModel();
        persistenceTableModel.setClassName(clazz.getCanonicalName());
        if (table.schema() == null) {
            throw new PersistenceException(MessageFormat.format("Table Name is mandatory, but it is not present in Class [{0}]", clazz.getCanonicalName()));
        }
        persistenceTableModel.setTableName(table.name());
        if (table.schema() != null) {
            persistenceTableModel.setSchemaName(table.schema());
        }
        this.parseColumns(clazz, persistenceTableModel);
        MODELS_CACHE.put(clazz, persistenceTableModel);
        return persistenceTableModel;
    }

    private Annotation getTableAnnotation(Class<? extends Object> clazz) {
        Table annotation = clazz.getAnnotation(Table.class);
        if (annotation == null && clazz.getSuperclass() != null) {
            return this.getTableAnnotation(clazz.getSuperclass());
        }
        return annotation;
    }

    private void parseColumns(Class<? extends Object> clazz, PersistenceTableModel persistenceModel) {
        Field[] fields;
        for (Field field : fields = PersistenceAnnotationsParser.collectFields(clazz)) {
            int length;
            boolean isTransient = Modifier.isTransient(field.getModifiers());
            if (isTransient) continue;
            Column annotationColumn = field.getAnnotation(Column.class);
            if (annotationColumn == null) {
                logger.warn(MessageFormat.format("No Column annotation found in Class {0} and Field {1}", clazz, field.getName()));
                continue;
            }
            Column column = annotationColumn;
            if (column.name() == null) {
                throw new PersistenceException(MessageFormat.format("Column Name is mandatory, but it is not present in Class [{0}] and Field [{1}]", clazz.getCanonicalName(), field.getName()));
            }
            String type = column.columnDefinition();
            if (type == null) {
                type = DataTypeUtils.getDatabaseTypeNameByJavaType(field.getType().getClass());
            }
            if ((length = column.length()) == 0 && DataTypeUtils.getDatabaseTypeByJavaType(field.getType().getClass()) == 12) {
                length = 512;
            }
            boolean unique = column.unique();
            Id annotationId = field.getAnnotation(Id.class);
            boolean primaryKey = annotationId != null;
            String generated = null;
            boolean identity = false;
            GeneratedValue annotationGeneratedValue = field.getAnnotation(GeneratedValue.class);
            if (annotationGeneratedValue != null) {
                GeneratedValue generatedValue = annotationGeneratedValue;
                if (generatedValue.strategy() == null || GenerationType.AUTO.equals((Object)generatedValue.strategy())) {
                    generated = GenerationType.TABLE.name();
                } else {
                    if (!(GenerationType.SEQUENCE.equals((Object)generatedValue.strategy()) || GenerationType.TABLE.equals((Object)generatedValue.strategy()) || GenerationType.IDENTITY.equals((Object)generatedValue.strategy()))) {
                        throw new IllegalArgumentException(MessageFormat.format("Generation Type: [{0}] not supported.", generatedValue.strategy().name()));
                    }
                    if (GenerationType.IDENTITY.equals((Object)generatedValue.strategy())) {
                        if (DataTypeUtils.isBigint((String)type) || DataTypeUtils.isVarchar((String)type) || DataTypeUtils.isChar((String)type) || DataTypeUtils.isInteger((String)type) || DataTypeUtils.isDecimal((String)type)) {
                            identity = true;
                        } else {
                            throw new IllegalArgumentException("Identity columns must of type CHAR, VARCHAR, INTEGER, BIGINT or DECIMAL");
                        }
                    }
                    generated = generatedValue.strategy().name();
                }
            }
            String enumerated = null;
            Enumerated annotationEnumerated = field.getAnnotation(Enumerated.class);
            if (annotationEnumerated != null) {
                Enumerated enumeratedAnnotation = annotationEnumerated;
                EnumType enumType = enumeratedAnnotation.value();
                enumerated = enumType.name();
                if (EnumType.ORDINAL.equals((Object)enumType)) {
                    type = DataType.INTEGER.name();
                } else {
                    type = DataType.VARCHAR.name();
                    length = 512;
                }
            }
            PersistenceTableColumnModel persistenceTableColumnModel = new PersistenceTableColumnModel(field.getName(), column.name(), type, length, column.nullable(), primaryKey, column.precision(), column.scale(), generated, unique, identity, enumerated);
            persistenceModel.getColumns().add(persistenceTableColumnModel);
        }
    }

    public static Field[] collectFields(Class<? extends Object> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            PersistenceAnnotationsParser.collectFieldsFromSuperclass(clazz.getSuperclass(), fields);
        }
        return fields.toArray(new Field[0]);
    }

    private static void collectFieldsFromSuperclass(Class<?> clazz, List<Field> fields) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            PersistenceAnnotationsParser.collectFieldsFromSuperclass(clazz.getSuperclass(), fields);
        }
    }
}

