/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.processors.identity;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.PersistenceManager;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.AbstractPersistenceProcessor;
import org.eclipse.dirigible.database.persistence.processors.identity.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceNextValueIdentityProcessor
extends AbstractPersistenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceNextValueIdentityProcessor.class);

    public PersistenceNextValueIdentityProcessor(IEntityManagerInterceptor entityManagerInterceptor) {
        super(entityManagerInterceptor);
    }

    @Override
    protected String generateScript(Connection connection, PersistenceTableModel tableModel) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextval(Connection connection, PersistenceTableModel tableModel) throws PersistenceException {
        Identity identity;
        logger.trace("nextval -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel));
        PersistenceManager<Identity> persistenceManager = new PersistenceManager<Identity>();
        if (!persistenceManager.tableExists(connection, Identity.class)) {
            persistenceManager.tableCreate(connection, Identity.class);
        }
        if ((identity = persistenceManager.find(connection, Identity.class, tableModel.getTableName())) == null) {
            identity = new Identity();
            identity.setTable(tableModel.getTableName());
            identity.setValue(1L);
            persistenceManager.insert(connection, identity);
            return 1L;
        }
        try {
            boolean autoCommit = connection.getAutoCommit();
            try {
                try {
                    if (autoCommit) {
                        connection.setAutoCommit(false);
                    }
                    identity = persistenceManager.lock(connection, Identity.class, tableModel.getTableName());
                    identity.setValue(identity.getValue() + 1L);
                    identity.setTable(tableModel.getTableName());
                    persistenceManager.update(connection, identity);
                }
                finally {
                    connection.commit();
                }
            }
            finally {
                connection.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        return identity.getValue();
    }
}

