/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.processors.sequence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.AbstractPersistenceProcessor;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.sequence.DropSequenceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceDropSequenceProcessor
extends AbstractPersistenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceDropSequenceProcessor.class);

    public PersistenceDropSequenceProcessor(IEntityManagerInterceptor entityManagerInterceptor) {
        super(entityManagerInterceptor);
    }

    @Override
    protected String generateScript(Connection connection, PersistenceTableModel tableModel) {
        DropSequenceBuilder dropSequenceBuilder = SqlFactory.getNative((ISqlDialect)SqlFactory.deriveDialect((Connection)connection)).drop().sequence(tableModel.getTableName() + "_" + "SEQUENCE");
        String sql = dropSequenceBuilder.toString();
        logger.trace(sql);
        return sql;
    }

    public int drop(Connection connection, PersistenceTableModel tableModel) throws PersistenceException {
        logger.trace("drop -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel));
        int result = 0;
        String sql = null;
        PreparedStatement preparedStatement = null;
        try {
            sql = this.generateScript(connection, tableModel);
            preparedStatement = this.openPreparedStatement(connection, sql);
            result = preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            try {
                logger.error(sql);
                logger.error(e.getMessage(), (Throwable)e);
                throw new PersistenceException(sql, e);
            }
            catch (Throwable throwable) {
                this.closePreparedStatement(preparedStatement);
                throw throwable;
            }
        }
        this.closePreparedStatement(preparedStatement);
        return result;
    }
}

