/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.processors.sequence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.AbstractPersistenceProcessor;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.sequence.NextValueSequenceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceNextValueSequenceProcessor
extends AbstractPersistenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceNextValueSequenceProcessor.class);

    public PersistenceNextValueSequenceProcessor(IEntityManagerInterceptor entityManagerInterceptor) {
        super(entityManagerInterceptor);
    }

    @Override
    protected String generateScript(Connection connection, PersistenceTableModel tableModel) {
        NextValueSequenceBuilder nextValueBuilder = SqlFactory.getNative((ISqlDialect)SqlFactory.deriveDialect((Connection)connection)).nextval(tableModel.getTableName() + "_" + "SEQUENCE");
        String sql = nextValueBuilder.toString();
        logger.trace(sql);
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long nextval(Connection connection, PersistenceTableModel tableModel) throws PersistenceException {
        PreparedStatement preparedStatement;
        long result;
        block11: {
            ResultSet resultSet;
            String sql;
            block9: {
                long l;
                block10: {
                    logger.trace("nextval -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel));
                    result = -1L;
                    sql = null;
                    preparedStatement = null;
                    sql = this.generateScript(connection, tableModel);
                    preparedStatement = this.openPreparedStatement(connection, sql);
                    resultSet = null;
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block9;
                    l = result = resultSet.getLong(1);
                    if (resultSet == null) break block10;
                    resultSet.close();
                }
                this.closePreparedStatement(preparedStatement);
                return l;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block11;
                {
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw new PersistenceException(sql, e);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(preparedStatement);
                    throw throwable;
                }
            }
        }
        this.closePreparedStatement(preparedStatement);
        return result;
    }
}

