/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.processors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.persistence.EnumType;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableColumnModel;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.PersistenceAnnotationsParser;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.IPersistenceProcessor;
import org.eclipse.dirigible.database.sql.DataTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistenceProcessor
implements IPersistenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPersistenceProcessor.class);
    private IEntityManagerInterceptor entityManagerInterceptor;

    public AbstractPersistenceProcessor() {
        this(null);
    }

    protected AbstractPersistenceProcessor(IEntityManagerInterceptor entityManagerInterceptor) {
        this.entityManagerInterceptor = entityManagerInterceptor;
    }

    protected abstract String generateScript(Connection var1, PersistenceTableModel var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValuesFromPojo(PersistenceTableModel tableModel, Object pojo, PreparedStatement preparedStatement) throws SQLException, NoSuchFieldException, IllegalAccessException {
        logger.trace("setValuesFromPojo -> tableModel: " + Serializer.serializeTableModel(tableModel) + ", pojo: " + Serializer.serializePojo(pojo));
        int i = 1;
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (!this.shouldSetColumnValue(columnModel) || columnModel.isIdentity()) continue;
            Field field = this.getFieldFromClass(pojo.getClass(), columnModel.getField());
            String dataType = columnModel.getType();
            Object valueObject = null;
            boolean oldAccessible = this.setAccessible(field);
            try {
                valueObject = field.get(pojo);
            }
            finally {
                this.resetAccessible(field, oldAccessible);
            }
            try {
                if (columnModel.getEnumerated() != null && valueObject != null) {
                    valueObject = EnumType.valueOf((String)columnModel.getEnumerated()).equals((Object)EnumType.ORDINAL) ? Integer.valueOf(((Enum)valueObject).ordinal()) : ((Enum)valueObject).name();
                }
                this.setValue(preparedStatement, i++, dataType, valueObject);
            }
            catch (PersistenceException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new PersistenceException(MessageFormat.format("Database type [{0}] not supported (Class: [{1}])", dataType, pojo.getClass()));
            }
        }
    }

    protected boolean shouldSetColumnValue(PersistenceTableColumnModel columnModel) {
        return true;
    }

    private void resetAccessible(Field field, boolean oldAccessible) {
        field.setAccessible(oldAccessible);
    }

    private boolean setAccessible(Field field) {
        boolean oldAccessible = field.isAccessible();
        field.setAccessible(true);
        return oldAccessible;
    }

    protected void setValuePrimaryKey(PersistenceTableModel tableModel, Object id, PreparedStatement preparedStatement) throws SQLException, NoSuchFieldException, IllegalAccessException {
        logger.trace("setValuePrimaryKey -> tableModel: " + Serializer.serializeTableModel(tableModel) + ", id: " + id);
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (!columnModel.isPrimaryKey()) continue;
            String dataType = columnModel.getType();
            this.setValue(preparedStatement, 1, dataType, id);
            break;
        }
    }

    protected void setValue(PreparedStatement preparedStatement, int i, Object value) throws SQLException {
        logger.trace("setValue -> i: " + i + ", value: " + value);
        this.setValue(preparedStatement, i, DataTypeUtils.getDatabaseTypeNameByJavaType(value.getClass()), value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setValue(PreparedStatement preparedStatement, int i, String dataType, Object value) throws SQLException {
        logger.trace("setValue -> i: " + i + ", dataType: " + dataType + ", value: " + value);
        if (this.getEntityManagerInterceptor() != null) {
            value = this.getEntityManagerInterceptor().onGetValueBeforeUpdate(i, dataType, value);
        }
        if (value == null) {
            preparedStatement.setNull(i, DataTypeUtils.getSqlTypeByDataType((String)dataType));
            return;
        } else if (DataTypeUtils.isVarchar((String)dataType)) {
            preparedStatement.setString(i, (String)value);
            return;
        } else if (DataTypeUtils.isNvarchar((String)dataType)) {
            preparedStatement.setString(i, (String)value);
            return;
        } else if (DataTypeUtils.isChar((String)dataType)) {
            if (value instanceof String) {
                preparedStatement.setString(i, (String)value);
                return;
            } else {
                if (!(value instanceof Character) && !Character.TYPE.getCanonicalName().equals(value.getClass().getCanonicalName())) throw new PersistenceException(MessageFormat.format("Database type [{0}] cannot be set as [{1}]", dataType, value.getClass().getName()));
                preparedStatement.setString(i, new String(new char[]{((Character)value).charValue()}));
            }
            return;
        } else if (DataTypeUtils.isDate((String)dataType)) {
            preparedStatement.setDate(i, (Date)value);
            return;
        } else if (DataTypeUtils.isTime((String)dataType)) {
            preparedStatement.setTime(i, (Time)value);
            return;
        } else if (DataTypeUtils.isTimestamp((String)dataType)) {
            preparedStatement.setTimestamp(i, (Timestamp)value);
            return;
        } else if (DataTypeUtils.isInteger((String)dataType)) {
            preparedStatement.setInt(i, (Integer)value);
            return;
        } else if (DataTypeUtils.isTinyint((String)dataType)) {
            preparedStatement.setByte(i, (Byte)value);
            return;
        } else if (DataTypeUtils.isSmallint((String)dataType)) {
            preparedStatement.setShort(i, (Short)value);
            return;
        } else if (DataTypeUtils.isBigint((String)dataType)) {
            if (value instanceof Long) {
                preparedStatement.setLong(i, (Long)value);
                return;
            } else {
                if (!(value instanceof BigInteger)) throw new PersistenceException(MessageFormat.format("Database type [{0}] cannot be set as [{1}]", dataType, value.getClass().getName()));
                preparedStatement.setLong(i, ((BigInteger)value).longValueExact());
            }
            return;
        } else if (DataTypeUtils.isReal((String)dataType)) {
            preparedStatement.setFloat(i, ((Float)value).floatValue());
            return;
        } else if (DataTypeUtils.isDouble((String)dataType)) {
            preparedStatement.setDouble(i, (Double)value);
            return;
        } else if (DataTypeUtils.isBoolean((String)dataType)) {
            preparedStatement.setBoolean(i, (Boolean)value);
            return;
        } else if (DataTypeUtils.isDecimal((String)dataType)) {
            if (value instanceof Double) {
                preparedStatement.setDouble(i, (Double)value);
                return;
            } else {
                if (!(value instanceof BigDecimal)) throw new PersistenceException(MessageFormat.format("Database type [{0}] cannot be set as [{1}]", dataType, value.getClass().getName()));
                preparedStatement.setBigDecimal(i, (BigDecimal)value);
            }
            return;
        } else if (DataTypeUtils.isBlob((String)dataType)) {
            byte[] bytes = (byte[])value;
            preparedStatement.setBinaryStream(i, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            return;
        } else {
            if (!DataTypeUtils.isBit((String)dataType)) throw new PersistenceException(MessageFormat.format("Database type [{0}] not supported", dataType));
            if (value instanceof Boolean || Boolean.TYPE.isInstance(value)) {
                preparedStatement.setBoolean(i, (Boolean)value);
                return;
            } else if (value instanceof Byte || Byte.TYPE.isInstance(value)) {
                preparedStatement.setBoolean(i, (Byte)value == 1);
                return;
            } else {
                if (!(value instanceof Integer) && !Integer.TYPE.isInstance(value)) throw new PersistenceException(MessageFormat.format("Database type [{0}] cannot be set as [{1}]", dataType, value.getClass().getName()));
                preparedStatement.setBoolean(i, (Integer)value == 1);
            }
        }
    }

    protected void setValueToPojo(Object pojo, ResultSet resultSet, PersistenceTableColumnModel columnModel) throws NoSuchFieldException, SQLException, IllegalAccessException, IOException {
        Object value = resultSet.getObject(columnModel.getName());
        this.setValueToPojo(pojo, value, columnModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setValueToPojo(Object pojo, Object value, PersistenceTableColumnModel columnModel) throws NoSuchFieldException, SQLException, IllegalAccessException, IOException {
        logger.trace("setValueToPojo -> pojo: " + Serializer.serializePojo(pojo) + ", value: " + value + ", columnModel: " + Serializer.serializeColumnModel(columnModel));
        Field field = this.getFieldFromClass(pojo.getClass(), columnModel.getField());
        boolean oldAccessible = this.setAccessible(field);
        try {
            if (columnModel.getEnumerated() != null) {
                if (EnumType.valueOf((String)columnModel.getEnumerated()).equals((Object)EnumType.ORDINAL) && value instanceof Integer) {
                    if (!field.getType().isEnum()) throw new IllegalStateException("The annotation @Enumerated is set to a field with a type, which is not an enum type.");
                    value = field.getType().getEnumConstants()[(Integer)value];
                } else if (EnumType.valueOf((String)columnModel.getEnumerated()).equals((Object)EnumType.STRING) && value instanceof String) {
                    if (!field.getType().isEnum()) throw new IllegalStateException("The annotation @Enumerated is set to a field with a type, which is not an enum type.");
                    value = Enum.valueOf(field.getType(), (String)value);
                } else if (value != null) {
                    throw new IllegalStateException("The annotation @Enumerated is misused, the value is unknown.");
                }
            }
            value = this.byteAdaptation(value, field);
            value = this.intAdaptation(value, field);
            value = this.blobAdaptation(value);
            value = this.charAdaptation(value, field);
            value = this.booleanAdaptation(value, field);
            value = this.bigIntegerAdaptation(value, field);
            value = this.shortAdaptation(value, field);
            value = this.floatAdaptation(value, field);
            if (this.getEntityManagerInterceptor() != null) {
                value = this.getEntityManagerInterceptor().onSetValueAfterQuery(pojo, field, value);
            }
            field.set(pojo, value);
            return;
        }
        finally {
            this.resetAccessible(field, oldAccessible);
        }
    }

    private Object floatAdaptation(Object value, Field field) {
        if (field.getType().equals(Float.TYPE) || field.getType().equals(Float.class)) {
            if (value instanceof Double) {
                value = Float.valueOf(((Double)value).floatValue());
            } else if (value instanceof Float) {
                value = (Float)value;
            }
        }
        return value;
    }

    private Object shortAdaptation(Object value, Field field) {
        if (field.getType().equals(Short.TYPE) || field.getType().equals(Short.class)) {
            if (value instanceof Long) {
                value = ((Long)value).shortValue();
            } else if (value instanceof Integer) {
                value = ((Integer)value).shortValue();
            } else if (value instanceof Byte) {
                value = ((Byte)value).shortValue();
            }
        }
        return value;
    }

    private Object bigIntegerAdaptation(Object value, Field field) {
        if (field.getType().equals(BigInteger.class) && value instanceof Long) {
            value = BigInteger.valueOf((Long)value);
        }
        return value;
    }

    private Object booleanAdaptation(Object value, Field field) {
        if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
            if (value instanceof Short) {
                value = (Short)value != 0;
            } else if (value instanceof Integer) {
                value = (Integer)value != 0;
            } else if (value instanceof Long) {
                value = (Long)value != 0L;
            }
        }
        return value;
    }

    private Object charAdaptation(Object value, Field field) {
        if (field.getType().equals(Character.TYPE) || field.getType().equals(Character.class)) {
            if (value instanceof String && ((String)value).length() <= 1) {
                value = new Character(((String)value).charAt(0));
            } else {
                throw new IllegalStateException("Trying to set a multi-character string to a single character field.");
            }
        }
        return value;
    }

    private Object blobAdaptation(Object value) throws IOException, SQLException {
        if (value instanceof Blob) {
            value = IOUtils.toByteArray((InputStream)((Blob)value).getBinaryStream());
        }
        return value;
    }

    private Object intAdaptation(Object value, Field field) {
        if ((field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) && value instanceof Long) {
            value = ((Long)value).intValue();
        }
        return value;
    }

    private Object byteAdaptation(Object value, Field field) {
        if (field.getType().equals(Byte.TYPE) || field.getType().equals(Byte.class)) {
            if (value instanceof Integer) {
                value = ((Integer)value).byteValue();
            } else if (value instanceof Short) {
                value = ((Short)value).byteValue();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValueFromPojo(Object pojo, PersistenceTableColumnModel columnModel) throws NoSuchFieldException, SQLException, IllegalAccessException {
        logger.trace("getValueFromPojo -> pojo: " + Serializer.serializePojo(pojo) + ", columnModel: " + Serializer.serializeColumnModel(columnModel));
        Field field = this.getFieldFromClass(pojo.getClass(), columnModel.getField());
        boolean oldAccessible = this.setAccessible(field);
        try {
            Object object = field.get(pojo);
            return object;
        }
        finally {
            this.resetAccessible(field, oldAccessible);
        }
    }

    private Field getFieldFromClass(Class clazz, String fieldName) throws NoSuchFieldException {
        Field field = null;
        List<Field> fields = Arrays.asList(PersistenceAnnotationsParser.collectFields(clazz));
        for (Field next : fields) {
            if (!next.getName().equals(fieldName)) continue;
            field = next;
            break;
        }
        if (field == null) {
            throw new NoSuchFieldException(MessageFormat.format("There is no a Field named [{0}] in the POJO of Class [{1}]", fieldName, clazz.getCanonicalName()));
        }
        return field;
    }

    protected PreparedStatement openPreparedStatement(Connection connection, String sql) throws SQLException {
        return connection.prepareStatement(sql);
    }

    protected void closePreparedStatement(PreparedStatement preparedStatement) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public String getPrimaryKey(PersistenceTableModel tableModel) {
        PersistenceTableColumnModel columnModel = this.getPrimaryKeyModel(tableModel);
        return columnModel == null ? null : columnModel.getName();
    }

    protected PersistenceTableColumnModel getPrimaryKeyModel(PersistenceTableModel tableModel) {
        Optional<PersistenceTableColumnModel> optional = tableModel.getColumns().stream().filter(model -> model.isPrimaryKey()).findFirst();
        return optional.orElse(null);
    }

    public IEntityManagerInterceptor getEntityManagerInterceptor() {
        return this.entityManagerInterceptor;
    }

    public void setEntityManagerInterceptor(IEntityManagerInterceptor entityManagerInterceptor) {
        this.entityManagerInterceptor = entityManagerInterceptor;
    }
}

