/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.processors.entity;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableColumnModel;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.AbstractPersistenceProcessor;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.records.UpdateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUpdateProcessor<T>
extends AbstractPersistenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceUpdateProcessor.class);

    public PersistenceUpdateProcessor(IEntityManagerInterceptor entityManagerInterceptor) {
        super(entityManagerInterceptor);
    }

    @Override
    protected String generateScript(Connection connection, PersistenceTableModel tableModel) {
        UpdateBuilder updateBuilder = SqlFactory.getNative((ISqlDialect)SqlFactory.deriveDialect((Connection)connection)).update().table(tableModel.getTableName());
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            if (columnModel.isPrimaryKey()) continue;
            updateBuilder.set(columnModel.getName(), "?");
        }
        updateBuilder.where(this.getPrimaryKey(tableModel) + " " + "=" + " " + "?");
        String sql = updateBuilder.toString();
        logger.trace(sql);
        return sql;
    }

    public int update(Connection connection, PersistenceTableModel tableModel, T pojo) throws PersistenceException {
        int n;
        logger.trace("update -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel) + ", pojo: " + Serializer.serializePojo(pojo));
        String sql = null;
        PreparedStatement preparedStatement = null;
        try {
            PersistenceTableColumnModel primaryKeyColumnModel = this.getPrimaryKeyModel(tableModel);
            Object id = this.getValueFromPojo(pojo, primaryKeyColumnModel);
            if (id == null) {
                throw new PersistenceException("The key for update cannot be null.");
            }
            sql = this.generateScript(connection, tableModel);
            preparedStatement = this.openPreparedStatement(connection, sql);
            this.setValuesFromPojo(tableModel, pojo, preparedStatement);
            this.setValue(preparedStatement, tableModel.getColumns().size(), id);
            n = preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            try {
                logger.error(sql);
                logger.error(e.getMessage(), (Throwable)e);
                throw new PersistenceException(sql, e);
            }
            catch (Throwable throwable) {
                this.closePreparedStatement(preparedStatement);
                throw throwable;
            }
        }
        this.closePreparedStatement(preparedStatement);
        return n;
    }

    @Override
    protected boolean shouldSetColumnValue(PersistenceTableColumnModel columnModel) {
        return !columnModel.isPrimaryKey();
    }
}

