/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.persistence.processors.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.eclipse.dirigible.database.persistence.IEntityManagerInterceptor;
import org.eclipse.dirigible.database.persistence.PersistenceException;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableColumnModel;
import org.eclipse.dirigible.database.persistence.model.PersistenceTableModel;
import org.eclipse.dirigible.database.persistence.parser.Serializer;
import org.eclipse.dirigible.database.persistence.processors.AbstractPersistenceProcessor;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlFactory;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceCreateTableProcessor
extends AbstractPersistenceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceCreateTableProcessor.class);

    public PersistenceCreateTableProcessor(IEntityManagerInterceptor entityManagerInterceptor) {
        super(entityManagerInterceptor);
    }

    @Override
    protected String generateScript(Connection connection, PersistenceTableModel tableModel) {
        CreateTableBuilder createTableBuilder = SqlFactory.getNative((ISqlDialect)SqlFactory.deriveDialect((Connection)connection)).create().table(tableModel.getTableName());
        for (PersistenceTableColumnModel columnModel : tableModel.getColumns()) {
            DataType dataType = DataType.valueOf((String)columnModel.getType());
            switch (dataType) {
                case VARCHAR: {
                    createTableBuilder.columnVarchar(columnModel.getName(), columnModel.getLength(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()), Boolean.valueOf(columnModel.isIdentity()));
                    break;
                }
                case NVARCHAR: {
                    createTableBuilder.columnNvarchar(columnModel.getName(), columnModel.getLength(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()), Boolean.valueOf(columnModel.isIdentity()));
                    break;
                }
                case CHAR: {
                    createTableBuilder.columnChar(columnModel.getName(), columnModel.getLength(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()), Boolean.valueOf(columnModel.isIdentity()), new String[0]);
                    break;
                }
                case DATE: {
                    createTableBuilder.columnDate(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()));
                    break;
                }
                case TIME: {
                    createTableBuilder.columnTime(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()));
                    break;
                }
                case TIMESTAMP: {
                    createTableBuilder.columnTimestamp(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()));
                    break;
                }
                case INTEGER: {
                    createTableBuilder.columnInteger(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()), Boolean.valueOf(columnModel.isIdentity()), new String[0]);
                    break;
                }
                case TINYINT: {
                    createTableBuilder.columnTinyint(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()));
                    break;
                }
                case BIGINT: {
                    createTableBuilder.columnBigint(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()), Boolean.valueOf(columnModel.isIdentity()), new String[0]);
                    break;
                }
                case SMALLINT: {
                    createTableBuilder.columnSmallint(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()));
                    break;
                }
                case REAL: {
                    createTableBuilder.columnReal(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()));
                    break;
                }
                case FLOAT: {
                    createTableBuilder.columnFloat(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()));
                    break;
                }
                case DOUBLE: {
                    createTableBuilder.columnDouble(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()));
                    break;
                }
                case BOOLEAN: {
                    createTableBuilder.columnBoolean(columnModel.getName(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()));
                    break;
                }
                case BLOB: {
                    createTableBuilder.columnBlob(columnModel.getName(), Boolean.valueOf(columnModel.isNullable()));
                    break;
                }
                case DECIMAL: {
                    createTableBuilder.columnDecimal(columnModel.getName(), columnModel.getPrecision(), columnModel.getScale(), Boolean.valueOf(columnModel.isPrimaryKey()), Boolean.valueOf(columnModel.isNullable()), Boolean.valueOf(columnModel.isUnique()), Boolean.valueOf(columnModel.isIdentity()), new String[0]);
                    break;
                }
                case BIT: {
                    createTableBuilder.columnBit(columnModel.getName(), Boolean.valueOf(columnModel.isNullable()));
                }
            }
        }
        String sql = createTableBuilder.build();
        logger.trace(sql);
        return sql;
    }

    public int create(Connection connection, PersistenceTableModel tableModel) throws PersistenceException {
        logger.trace("create -> connection: " + connection.hashCode() + ", tableModel: " + Serializer.serializeTableModel(tableModel));
        int result = 0;
        String sql = null;
        PreparedStatement preparedStatement = null;
        try {
            sql = this.generateScript(connection, tableModel);
            preparedStatement = this.openPreparedStatement(connection, sql);
            result = preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            try {
                logger.error(sql);
                logger.error(e.getMessage(), (Throwable)e);
                throw new PersistenceException(sql, e);
            }
            catch (Throwable throwable) {
                this.closePreparedStatement(preparedStatement);
                throw throwable;
            }
        }
        this.closePreparedStatement(preparedStatement);
        return result;
    }
}

