/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.database.sql.DataType;
import org.eclipse.dirigible.database.sql.SqlException;

public class DataTypeUtils {
    public static final int VARCHAR_DEFAULT_LENGTH = 512;
    public static final int DECIMAL_DEFAULT_LENGTH = 100000;
    private static final String JSONB = "JSONB";
    private static final String JSON = "JSON";
    private static final String ARRAY = "ARRAY";
    private static final String BYTEA = "BYTEA";
    private static final String BINARY_LARGE_OBJECT = "BINARY LARGE OBJECT";
    private static final String BINARY_VARYING = "BINARY VARYING";
    private static final String BINARY = "BINARY";
    private static final String BLOB = "BLOB";
    private static final String CHARACTER_LARGE_OBJECT = "CHARACTER LARGE OBJECT";
    private static final String CLOB = "CLOB";
    private static final String BOOL = "BOOL";
    private static final String BOOLEAN = "BOOLEAN";
    private static final String DECIMAL = "DECIMAL";
    private static final String NUMERIC = "NUMERIC";
    private static final String NUMBER = "NUMBER";
    private static final String FLOAT8 = "FLOAT8";
    private static final String FLOAT4 = "FLOAT4";
    private static final String DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String DOUBLE = "DOUBLE";
    private static final String FLOAT = "FLOAT";
    private static final String REAL = "REAL";
    private static final String SERIAL8 = "SERIAL8";
    private static final String BIGSERIAL = "BIGSERIAL";
    private static final String BIGINT = "BIGINT";
    private static final String INT8 = "INT8";
    private static final String INT4 = "INT4";
    private static final String INT2 = "INT2";
    private static final String INT = "INT";
    private static final String INTEGER = "INTEGER";
    private static final String TINYINT = "TINYINT";
    private static final String SMALLINT = "SMALLINT";
    private static final String BIT = "BIT";
    private static final String TIME = "TIME";
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final String DATE = "DATE";
    private static final String TEXT = "TEXT";
    private static final String CHARACTER = "CHARACTER";
    private static final String BPCHAR = "BPCHAR";
    private static final String CHAR = "CHAR";
    private static final String NVARCHAR = "NVARCHAR";
    private static final String CHARACTER_VARYING = "CHARACTER VARYING";
    private static final String VARCHAR = "VARCHAR";
    private static final Map<Integer, DataType> DATABASE_TYPE_TO_DATA_TYPE = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Integer> STRING_TO_DATABASE_TYPE = Collections.synchronizedMap(new HashMap());
    private static final Map<Class, Integer> JAVA_TYPE_TO_DATABASE_TYPE = Collections.synchronizedMap(new HashMap());
    private static final Map<Integer, Class> DATABASE_TYPE_TO_JAVA_TYPE = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> UNIFIED_STRING_FROM_DATABASE_TYPE = Collections.synchronizedMap(new HashMap());

    public static DataType getDatabaseType(Integer type) {
        if (DataTypeUtils.isDatabaseTypeSupported(type)) {
            return DATABASE_TYPE_TO_DATA_TYPE.get(type);
        }
        throw new SqlException(MessageFormat.format("Type {0} not supported", type));
    }

    public static boolean isDatabaseTypeSupported(Integer type) {
        return DATABASE_TYPE_TO_DATA_TYPE.containsKey(type);
    }

    public static Class getJavaTypeByDatabaseType(Integer type) {
        Class clazz = DATABASE_TYPE_TO_JAVA_TYPE.get(type);
        if (clazz == null) {
            throw new SqlException(MessageFormat.format("Type {0} does not have mapping to a java type", type));
        }
        return clazz;
    }

    public static Integer getSqlTypeByDataType(String type) {
        if (STRING_TO_DATABASE_TYPE.containsKey(type = type.toUpperCase())) {
            return STRING_TO_DATABASE_TYPE.get(type);
        }
        throw new SqlException(MessageFormat.format("Type {0} not supported", type));
    }

    public static String getDatabaseTypeNameByJavaType(Class clazz) {
        Integer type = DataTypeUtils.getDatabaseTypeByJavaType(clazz);
        return DataTypeUtils.getDatabaseTypeName(type);
    }

    public static String getDatabaseTypeName(Integer type) {
        if (DataTypeUtils.isDatabaseTypeSupported(type)) {
            return DATABASE_TYPE_TO_DATA_TYPE.get(type).toString();
        }
        throw new SqlException(MessageFormat.format("Type [{0}] not supported. Supported tpes [{1}]", type, DATABASE_TYPE_TO_DATA_TYPE));
    }

    public static Integer getDatabaseTypeByJavaType(Class clazz) {
        Integer type = JAVA_TYPE_TO_DATABASE_TYPE.get(clazz);
        if (type == null) {
            for (Map.Entry<Class, Integer> entry : JAVA_TYPE_TO_DATABASE_TYPE.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                return entry.getValue();
            }
            throw new SqlException(MessageFormat.format("Class {0} does not have mapping to a data type", clazz));
        }
        return type;
    }

    public static String getUnifiedDatabaseType(String type) {
        if (UNIFIED_STRING_FROM_DATABASE_TYPE.containsKey(type)) {
            return UNIFIED_STRING_FROM_DATABASE_TYPE.get(type);
        }
        return type;
    }

    public static boolean isBlob(String dataType) {
        return DataType.BLOB.isOfType(dataType);
    }

    public static boolean isBoolean(String dataType) {
        return DataType.BOOLEAN.isOfType(dataType);
    }

    public static boolean isDouble(String dataType) {
        return DataType.DOUBLE.isOfType(dataType);
    }

    public static boolean isReal(String dataType) {
        return DataType.REAL.isOfType(dataType);
    }

    public static boolean isFloat(String dataType) {
        return DataType.FLOAT.isOfType(dataType);
    }

    public static boolean isBigint(String dataType) {
        return DataType.BIGINT.isOfType(dataType);
    }

    public static boolean isSmallint(String dataType) {
        return DataType.SMALLINT.isOfType(dataType);
    }

    public static boolean isInteger(String dataType) {
        return DataType.INTEGER.isOfType(dataType) || DataType.INT.isOfType(dataType);
    }

    public static boolean isTinyint(String dataType) {
        return DataType.TINYINT.isOfType(dataType);
    }

    public static boolean isTimestamp(String dataType) {
        return DataType.TIMESTAMP.isOfType(dataType);
    }

    public static boolean isDateTime(String dataType) {
        return DataType.DATETIME.isOfType(dataType);
    }

    public static boolean isTime(String dataType) {
        return DataType.TIME.isOfType(dataType);
    }

    public static boolean isDate(String dataType) {
        return DataType.DATE.isOfType(dataType);
    }

    public static boolean isChar(String dataType) {
        return DataType.CHAR.isOfType(dataType);
    }

    public static boolean isVarchar(String dataType) {
        return DataType.VARCHAR.isOfType(dataType);
    }

    public static boolean isText(String dataType) {
        return DataType.TEXT.isOfType(dataType);
    }

    public static boolean isCharacterVarying(String dataType) {
        return DataType.CHARACTER_VARYING.isOfType(dataType);
    }

    public static boolean isNvarchar(String dataType) {
        return DataType.NVARCHAR.isOfType(dataType);
    }

    public static boolean isDecimal(String dataType) {
        return DataType.DECIMAL.isOfType(dataType);
    }

    public static boolean isBit(String dataType) {
        return DataType.BIT.isOfType(dataType);
    }

    public static boolean isArray(String dataType) {
        return DataType.ARRAY.isOfType(dataType);
    }

    static {
        DATABASE_TYPE_TO_DATA_TYPE.put(12, DataType.VARCHAR);
        DATABASE_TYPE_TO_DATA_TYPE.put(-9, DataType.NVARCHAR);
        DATABASE_TYPE_TO_DATA_TYPE.put(1, DataType.CHAR);
        DATABASE_TYPE_TO_DATA_TYPE.put(93, DataType.TIMESTAMP);
        DATABASE_TYPE_TO_DATA_TYPE.put(93, DataType.DATETIME);
        DATABASE_TYPE_TO_DATA_TYPE.put(92, DataType.TIME);
        DATABASE_TYPE_TO_DATA_TYPE.put(4, DataType.INTEGER);
        DATABASE_TYPE_TO_DATA_TYPE.put(4, DataType.INT);
        DATABASE_TYPE_TO_DATA_TYPE.put(-5, DataType.BIGINT);
        DATABASE_TYPE_TO_DATA_TYPE.put(5, DataType.SMALLINT);
        DATABASE_TYPE_TO_DATA_TYPE.put(7, DataType.REAL);
        DATABASE_TYPE_TO_DATA_TYPE.put(6, DataType.FLOAT);
        DATABASE_TYPE_TO_DATA_TYPE.put(8, DataType.DOUBLE);
        DATABASE_TYPE_TO_DATA_TYPE.put(91, DataType.DATE);
        DATABASE_TYPE_TO_DATA_TYPE.put(16, DataType.BOOLEAN);
        DATABASE_TYPE_TO_DATA_TYPE.put(2004, DataType.BLOB);
        DATABASE_TYPE_TO_DATA_TYPE.put(3, DataType.DECIMAL);
        DATABASE_TYPE_TO_DATA_TYPE.put(-7, DataType.BIT);
        DATABASE_TYPE_TO_DATA_TYPE.put(2003, DataType.ARRAY);
        STRING_TO_DATABASE_TYPE.put(VARCHAR, 12);
        STRING_TO_DATABASE_TYPE.put(CHARACTER_VARYING, 12);
        STRING_TO_DATABASE_TYPE.put(NVARCHAR, -9);
        STRING_TO_DATABASE_TYPE.put(CHAR, 1);
        STRING_TO_DATABASE_TYPE.put(BPCHAR, 1);
        STRING_TO_DATABASE_TYPE.put(CHARACTER, 1);
        STRING_TO_DATABASE_TYPE.put(TEXT, 12);
        STRING_TO_DATABASE_TYPE.put(DATE, 91);
        STRING_TO_DATABASE_TYPE.put(TIMESTAMP, 93);
        STRING_TO_DATABASE_TYPE.put(TIME, 92);
        STRING_TO_DATABASE_TYPE.put(BIT, -7);
        STRING_TO_DATABASE_TYPE.put(SMALLINT, 5);
        STRING_TO_DATABASE_TYPE.put(TINYINT, 5);
        STRING_TO_DATABASE_TYPE.put(INTEGER, 4);
        STRING_TO_DATABASE_TYPE.put(INT, 4);
        STRING_TO_DATABASE_TYPE.put(INT2, 4);
        STRING_TO_DATABASE_TYPE.put(INT4, 4);
        STRING_TO_DATABASE_TYPE.put(INT8, -5);
        STRING_TO_DATABASE_TYPE.put(BIGINT, -5);
        STRING_TO_DATABASE_TYPE.put(BIGSERIAL, -5);
        STRING_TO_DATABASE_TYPE.put(SERIAL8, -5);
        STRING_TO_DATABASE_TYPE.put(REAL, 7);
        STRING_TO_DATABASE_TYPE.put(FLOAT, 6);
        STRING_TO_DATABASE_TYPE.put(DOUBLE, 8);
        STRING_TO_DATABASE_TYPE.put(DOUBLE_PRECISION, 8);
        STRING_TO_DATABASE_TYPE.put(FLOAT4, 7);
        STRING_TO_DATABASE_TYPE.put(FLOAT8, 8);
        STRING_TO_DATABASE_TYPE.put(NUMERIC, 2);
        STRING_TO_DATABASE_TYPE.put(DECIMAL, 3);
        STRING_TO_DATABASE_TYPE.put(NUMBER, 3);
        STRING_TO_DATABASE_TYPE.put(BOOLEAN, 16);
        STRING_TO_DATABASE_TYPE.put(BOOL, 16);
        STRING_TO_DATABASE_TYPE.put(CLOB, 2005);
        STRING_TO_DATABASE_TYPE.put(CHARACTER_LARGE_OBJECT, 2005);
        STRING_TO_DATABASE_TYPE.put(BLOB, 2004);
        STRING_TO_DATABASE_TYPE.put(BINARY, 2004);
        STRING_TO_DATABASE_TYPE.put(BINARY_VARYING, 2004);
        STRING_TO_DATABASE_TYPE.put(BINARY_LARGE_OBJECT, 2004);
        STRING_TO_DATABASE_TYPE.put(BYTEA, 2004);
        STRING_TO_DATABASE_TYPE.put(ARRAY, 2003);
        STRING_TO_DATABASE_TYPE.put(JSON, 1111);
        STRING_TO_DATABASE_TYPE.put(JSONB, 1111);
        JAVA_TYPE_TO_DATABASE_TYPE.put(String.class, 12);
        JAVA_TYPE_TO_DATABASE_TYPE.put(String.class, -9);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Integer.class, 4);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Integer.TYPE, 4);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Long.class, -5);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Long.TYPE, -5);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Float.class, 6);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Float.TYPE, 6);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Double.class, 8);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Double.TYPE, 8);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Boolean.class, 16);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Boolean.TYPE, 16);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Date.class, 93);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Time.class, 92);
        JAVA_TYPE_TO_DATABASE_TYPE.put(Timestamp.class, 93);
        JAVA_TYPE_TO_DATABASE_TYPE.put(byte[].class, 2004);
        JAVA_TYPE_TO_DATABASE_TYPE.put(List.class, 2003);
        DATABASE_TYPE_TO_JAVA_TYPE.put(12, String.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(-9, String.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(1, String.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(93, Timestamp.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(92, Time.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(5, Integer.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(4, Integer.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(-5, Long.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(7, Float.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(6, Float.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(8, Double.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(3, Double.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(91, Date.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(16, Boolean.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(2004, byte[].class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(3, Double.class);
        DATABASE_TYPE_TO_JAVA_TYPE.put(-7, Boolean.TYPE);
        DATABASE_TYPE_TO_JAVA_TYPE.put(2003, List.class);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(CHARACTER_VARYING, VARCHAR);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(NVARCHAR, VARCHAR);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(CHARACTER, CHAR);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(TINYINT, SMALLINT);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(INT, INTEGER);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(INT2, INTEGER);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(INT4, INTEGER);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(INT8, BIGINT);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(BIGSERIAL, BIGINT);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(SERIAL8, BIGINT);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(DOUBLE_PRECISION, DOUBLE);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(FLOAT4, REAL);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(FLOAT8, DOUBLE);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(BOOL, BOOLEAN);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(CHARACTER_LARGE_OBJECT, CLOB);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(BINARY, BLOB);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(BINARY_VARYING, BLOB);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(BINARY_LARGE_OBJECT, BLOB);
        UNIFIED_STRING_FROM_DATABASE_TYPE.put(BYTEA, BLOB);
    }
}

