/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders;

import java.util.List;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractSqlBuilder;

public abstract class AbstractQuerySqlBuilder
extends AbstractSqlBuilder {
    protected AbstractQuerySqlBuilder(ISqlDialect dialect) {
        super(dialect);
    }

    protected void generateCreate(StringBuilder sql) {
        sql.append("CREATE");
    }

    protected void generateWhere(StringBuilder sql, List<String> wheres) {
        if (!wheres.isEmpty()) {
            sql.append(" ").append("WHERE").append(" ").append(this.traverseWheres(wheres));
        }
    }

    protected void generateOrderBy(StringBuilder sql, List<String> orders) {
        if (!orders.isEmpty()) {
            sql.append(" ").append("ORDER BY").append(" ").append(this.traverseOrders(orders));
        }
    }

    protected void generateLimitAndOffset(StringBuilder sql, int limit, int offset) {
        if (limit > -1) {
            sql.append(" ").append("LIMIT").append(" ").append(limit);
        }
        if (offset > -1) {
            sql.append(" ").append("OFFSET").append(" ").append(offset);
        }
    }

    private String traverseWheres(List<String> wheres) {
        StringBuilder snippet = new StringBuilder();
        for (String where : wheres) {
            where = this.isCaseSensitive() ? this.encapsulateWhere(where) : where;
            snippet.append(where).append(" ").append("AND").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 5);
    }

    private String traverseOrders(List<String> orders) {
        StringBuilder snippet = new StringBuilder();
        for (String order : orders) {
            snippet.append(order).append(",").append(" ");
        }
        return snippet.toString().substring(0, snippet.length() - 2);
    }

    @Override
    public String toString() {
        return this.generate();
    }
}

