/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.schema;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractCreateSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSchemaBuilder
extends AbstractCreateSqlBuilder {
    private static final String AUTHORIZATION_KEYWORD = "AUTHORIZATION";
    private static final Logger logger = LoggerFactory.getLogger(CreateSchemaBuilder.class);
    private final String name;
    private String authorization;

    public CreateSchemaBuilder(ISqlDialect dialect, String name) {
        super(dialect);
        this.name = name;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateCreate(sql);
        this.generateSchema(sql);
        this.generateAuthorization(sql);
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateSchema(StringBuilder sql) {
        String schemaName = this.isCaseSensitive() ? this.encapsulate(this.getName(), true) : this.getName();
        sql.append(" ").append("SCHEMA").append(" ").append(schemaName);
    }

    public String getName() {
        return this.name;
    }

    public CreateSchemaBuilder authorization(String roleSpecification) {
        this.authorization = roleSpecification;
        return this;
    }

    private void generateAuthorization(StringBuilder sql) {
        if (null == this.authorization) {
            return;
        }
        sql.append(" ").append(AUTHORIZATION_KEYWORD).append(" ").append(this.getEscapeSymbol()).append(this.authorization).append(this.getEscapeSymbol());
    }
}

