/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.sequence;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.sequence.CreateSequenceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterSequenceBuilder
extends CreateSequenceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AlterSequenceBuilder.class);
    private Integer restartWith;

    public CreateSequenceBuilder restartWith(Integer restartWith) {
        if (logger.isTraceEnabled()) {
            logger.trace("restartWith: " + restartWith);
        }
        this.restartWith = restartWith;
        return this;
    }

    public AlterSequenceBuilder(ISqlDialect dialect, String sequence) {
        super(dialect, sequence);
    }

    protected void generateRestartWith(StringBuilder sql) {
        if (this.restartWith != null) {
            this.generateSequenceParameter(sql, "RESTART WITH", String.valueOf(this.restartWith));
        }
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateAlter(sql);
        this.generateSequence(sql);
        this.generateStart(sql);
        this.generateIncrement(sql);
        this.generateMaxvalue(sql);
        this.generateNomaxvalue(sql);
        this.generateMinvalue(sql);
        this.generateNominvalue(sql);
        this.generateCycle(sql);
        this.generateResetBy(sql);
        this.generateRestartWith(sql);
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    @Override
    protected void generateStart(StringBuilder sql) {
        if (this.getStart() != null) {
            this.generateSequenceParameter(sql, "RESTART WITH", String.valueOf(this.getStart()));
        }
    }
}

