/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.sequence;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractDropSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropSequenceBuilder
extends AbstractDropSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DropSequenceBuilder.class);
    private final String sequence;
    private String dropOption;

    public DropSequenceBuilder(ISqlDialect dialect, String sequence) {
        super(dialect);
        this.sequence = sequence;
    }

    public DropSequenceBuilder(ISqlDialect dialect, String sequence, String dropOption) {
        super(dialect);
        this.sequence = sequence;
        this.dropOption = dropOption;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateDrop(sql);
        this.generateSequence(sql);
        this.generateDropOption(sql);
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateDropOption(StringBuilder sql) {
        if (this.dropOption != null) {
            sql.append(" ").append(this.dropOption);
        }
    }

    protected void generateSequence(StringBuilder sql) {
        String sequenceName = this.isCaseSensitive() ? this.encapsulate(this.getSequence(), true) : this.getSequence();
        sql.append(" ").append("SEQUENCE").append(" ").append(sequenceName);
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setDropOption(String dropOption) {
        this.dropOption = dropOption;
    }

    public DropSequenceBuilder unsetDropOption() {
        this.dropOption = null;
        return this;
    }
}

