/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.SqlException;
import org.eclipse.dirigible.database.sql.TableStatements;
import org.eclipse.dirigible.database.sql.builders.table.AbstractTableBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableCheckBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableForeignKeyBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableIndexBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTablePrimaryKeyBuilder;
import org.eclipse.dirigible.database.sql.builders.table.CreateTableUniqueIndexBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableBuilder<TABLE_BUILDER extends CreateTableBuilder>
extends AbstractTableBuilder<TABLE_BUILDER> {
    private static final Logger logger = LoggerFactory.getLogger(CreateTableBuilder.class);
    protected CreateTablePrimaryKeyBuilder primaryKey;
    protected final List<CreateTableForeignKeyBuilder> foreignKeys = new ArrayList<CreateTableForeignKeyBuilder>();
    protected final List<CreateTableUniqueIndexBuilder> uniqueIndices = new ArrayList<CreateTableUniqueIndexBuilder>();
    protected final List<CreateTableCheckBuilder> checks = new ArrayList<CreateTableCheckBuilder>();
    protected final List<CreateTableIndexBuilder> indices = new ArrayList<CreateTableIndexBuilder>();
    public static final String STATEMENT_DELIMITER = "; ";

    public CreateTableBuilder(ISqlDialect dialect, String table) {
        super(dialect, table);
    }

    @Override
    public TABLE_BUILDER primaryKey(String name, String[] columns) {
        if (logger.isTraceEnabled()) {
            logger.trace("primaryKey: " + name + ", columns" + Arrays.toString(columns));
        }
        if (this.primaryKey != null) {
            throw new SqlException("Setting of primary key must be called only once");
        }
        this.primaryKey = new CreateTablePrimaryKeyBuilder(this.getDialect(), name);
        for (String column : columns) {
            this.primaryKey.column(column);
        }
        return (TABLE_BUILDER)this;
    }

    public TABLE_BUILDER primaryKey(String name, String columns) {
        if (logger.isTraceEnabled()) {
            logger.trace("primaryKey: " + name + ", columns" + columns);
        }
        String[] array = this.splitValues(columns);
        return (TABLE_BUILDER)this.primaryKey(name, array);
    }

    @Override
    public TABLE_BUILDER primaryKey(String[] columns) {
        if (logger.isTraceEnabled()) {
            logger.trace("primaryKey: <unnamed>, columns" + Arrays.toString(columns));
        }
        return (TABLE_BUILDER)this.primaryKey(null, columns);
    }

    public TABLE_BUILDER primaryKey(String columns) {
        if (logger.isTraceEnabled()) {
            logger.trace("primaryKey: <unnamed>, columns" + columns);
        }
        return (TABLE_BUILDER)this.primaryKey(null, this.splitValues(columns));
    }

    public TABLE_BUILDER foreignKey(String name, String[] columns, String referencedTable, String[] referencedColumns) {
        return (TABLE_BUILDER)this.foreignKey(name, columns, referencedTable, null, referencedColumns);
    }

    @Override
    public TABLE_BUILDER foreignKey(String name, String[] columns, String referencedTable, String referencedTableSchema, String[] referencedColumns) {
        if (logger.isTraceEnabled()) {
            logger.trace("foreignKey: " + name + ", columns" + Arrays.toString(columns) + ", referencedTable: " + referencedTable + ", referencedTableSchema: " + referencedTableSchema + ", referencedColumns: " + Arrays.toString(referencedColumns));
        }
        CreateTableForeignKeyBuilder foreignKey = new CreateTableForeignKeyBuilder(this.getDialect(), name);
        for (String column : columns) {
            foreignKey.column(column);
        }
        foreignKey.referencedTable(referencedTable);
        for (String column : referencedColumns) {
            foreignKey.referencedColumn(column);
        }
        foreignKey.referencedTableSchema(referencedTableSchema);
        this.foreignKeys.add(foreignKey);
        return (TABLE_BUILDER)this;
    }

    public TABLE_BUILDER foreignKey(String name, String columns, String referencedTable, String referencedTableSchema, String referencedColumns) {
        if (logger.isTraceEnabled()) {
            logger.trace("foreignKey: " + name + ", columns" + columns + ", referencedTable: " + referencedTable + ", referencedColumns: " + referencedColumns);
        }
        return (TABLE_BUILDER)this.foreignKey(name, this.splitValues(columns), referencedTable, referencedTableSchema, this.splitValues(referencedColumns));
    }

    @Override
    public TABLE_BUILDER unique(String name, String[] columns) {
        if (logger.isTraceEnabled()) {
            logger.trace("unique: " + name + ", columns" + Arrays.toString(columns));
        }
        CreateTableUniqueIndexBuilder uniqueIndex = new CreateTableUniqueIndexBuilder(this.getDialect(), name);
        for (String column : columns) {
            uniqueIndex.column(column);
        }
        this.uniqueIndices.add(uniqueIndex);
        return (TABLE_BUILDER)this;
    }

    public TABLE_BUILDER unique(String name, String columns) {
        if (logger.isTraceEnabled()) {
            logger.trace("unique: " + name + ", columns" + columns);
        }
        return (TABLE_BUILDER)this.unique(name, this.splitValues(columns));
    }

    @Override
    public TABLE_BUILDER unique(String name, String[] columns, String type, String order) {
        return (TABLE_BUILDER)this.unique(name, columns);
    }

    @Override
    public TABLE_BUILDER check(String name, String expression) {
        if (logger.isTraceEnabled()) {
            logger.trace("check: " + name + ", expression" + expression);
        }
        CreateTableCheckBuilder check = new CreateTableCheckBuilder(this.getDialect(), name);
        check.expression(expression);
        this.checks.add(check);
        return (TABLE_BUILDER)this;
    }

    @Override
    public TABLE_BUILDER index(String name, Boolean isUnique, String order, String type, Set<String> columns) {
        if (logger.isTraceEnabled()) {
            logger.trace("index: " + name + ", isUnique" + isUnique + ", type" + type + ", columns" + String.valueOf(columns));
        }
        CreateTableIndexBuilder index = new CreateTableIndexBuilder(this.getDialect(), name);
        index.setIndexType(type);
        index.setUnique(isUnique);
        index.setOrder(order);
        index.setColumns(columns);
        this.indices.add(index);
        return (TABLE_BUILDER)this;
    }

    @Override
    public String generate() {
        TableStatements table = this.buildTable();
        String generated = table.getCreateTableStatement();
        if (!table.getCreateIndicesStatements().isEmpty()) {
            String uniqueIndices = table.getCreateIndicesStatements().stream().collect(Collectors.joining(STATEMENT_DELIMITER));
            generated = String.join((CharSequence)STATEMENT_DELIMITER, generated, uniqueIndices);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    public TableStatements buildTable() {
        StringBuilder sql = new StringBuilder();
        this.generateCreate(sql);
        this.generateTable(sql);
        sql.append(" ").append("(");
        this.generateColumns(sql);
        this.generatePrimaryKey(sql);
        this.generateForeignKeys(sql);
        this.generateChecks(sql);
        sql.append(")");
        String createTableStatement = sql.toString();
        HashSet<String> createIndicesStatements = new HashSet<String>();
        createIndicesStatements.addAll(this.generateIndices());
        createIndicesStatements.addAll(this.generateUniqueIndices());
        return new TableStatements(createTableStatement, createIndicesStatements);
    }

    protected void generatePrimaryKey(StringBuilder sql) {
        boolean isCompositeKey;
        List<String[]> allPrimaryKeys = this.getColumns().stream().filter(el -> Arrays.stream(el).anyMatch(x -> x.equals(this.getDialect().getPrimaryKeyArgument()))).collect(Collectors.toList());
        boolean bl = isCompositeKey = allPrimaryKeys.size() > 1;
        if (this.primaryKey != null && allPrimaryKeys.size() == 0 && !this.primaryKey.getColumns().isEmpty()) {
            sql.append(",").append(" ");
            if (this.primaryKey.getName() != null) {
                String primaryKeyName = this.isCaseSensitive() ? this.encapsulate(this.primaryKey.getName()) : this.primaryKey.getName();
                sql.append("CONSTRAINT").append(" ").append(primaryKeyName).append(" ");
            }
            sql.append("PRIMARY").append(" ").append("KEY").append(" ").append("(").append(this.traverseNames(this.primaryKey.getColumns())).append(")");
        } else if (isCompositeKey) {
            sql.append(",").append(" ");
            ArrayList keys = new ArrayList();
            allPrimaryKeys.forEach(el -> keys.add(el[0]));
            sql.append("PRIMARY").append(" ").append("KEY").append("(").append(String.join((CharSequence)" , ", keys)).append(")").append(" ");
        }
    }

    protected void generateForeignKeys(StringBuilder sql) {
        for (CreateTableForeignKeyBuilder foreignKey : this.foreignKeys) {
            this.generateForeignKey(sql, foreignKey);
        }
    }

    protected void generateForeignKey(StringBuilder sql, CreateTableForeignKeyBuilder foreignKey) {
        if (foreignKey != null) {
            sql.append(",").append(" ");
            if (foreignKey.getName() != null) {
                String foreignKeyName = this.isCaseSensitive() ? this.encapsulate(foreignKey.getName()) : foreignKey.getName();
                sql.append("CONSTRAINT").append(" ").append(foreignKeyName).append(" ");
            }
            String referencedTableName = this.isCaseSensitive() ? this.encapsulate(foreignKey.getReferencedTable(), true) : foreignKey.getReferencedTable();
            sql.append("FOREIGN").append(" ").append("KEY").append(" ").append("(").append(this.traverseNames(foreignKey.getColumns())).append(")").append(" ").append("REFERENCES").append(" ");
            if (foreignKey.getReferencedTableSchema() != null) {
                sql.append(foreignKey.getReferencedTableSchema()).append(".");
            }
            sql.append(referencedTableName).append("(").append(this.traverseNames(foreignKey.getReferencedColumns())).append(")");
        }
    }

    protected Collection<String> generateUniqueIndices() {
        HashSet<String> indices = new HashSet<String>();
        for (CreateTableUniqueIndexBuilder uniqueIndex : this.uniqueIndices) {
            indices.add(this.generateUniqueIndex(uniqueIndex));
        }
        return indices;
    }

    protected String generateUniqueIndex(CreateTableUniqueIndexBuilder uniqueIndex) {
        StringBuilder sql = new StringBuilder();
        if (uniqueIndex != null) {
            sql.append("CREATE").append(" ");
            sql.append("UNIQUE").append(" ");
            if (uniqueIndex.getIndexType() != null) {
                sql.append(uniqueIndex.getIndexType()).append(" ");
            }
            sql.append("INDEX").append(" ");
            if (uniqueIndex.getName() != null) {
                sql.append(uniqueIndex.getName()).append(" ");
            }
            sql.append("ON").append(" ").append(this.getTable());
            sql.append(" ").append("(").append(this.traverseNames(uniqueIndex.getColumns())).append(")");
            if (uniqueIndex.getOrder() != null) {
                sql.append(" ").append(uniqueIndex.getOrder());
            }
        }
        return sql.toString();
    }

    protected void generateChecks(StringBuilder sql) {
        for (CreateTableCheckBuilder index : this.checks) {
            this.generateCheck(sql, index);
        }
    }

    protected void generateCheck(StringBuilder sql, CreateTableCheckBuilder check) {
        if (check != null) {
            sql.append(",").append(" ");
            if (check.getName() != null) {
                String checkName = this.isCaseSensitive() ? this.encapsulate(check.getName()) : check.getName();
                sql.append("CONSTRAINT").append(" ").append(checkName).append(" ");
            }
            sql.append("CHECK").append(" ").append("(").append(check.getExpression()).append(")");
        }
    }

    protected Collection<String> generateIndices() {
        HashSet<String> indices = new HashSet<String>();
        for (CreateTableIndexBuilder index : this.indices) {
            indices.add(this.generateIndex(index));
        }
        return indices;
    }

    protected String generateIndex(CreateTableIndexBuilder index) {
        StringBuilder sql = new StringBuilder();
        if (index != null && !index.isUnique().booleanValue()) {
            sql.append("CREATE").append(" ");
            if (index.getIndexType() != null) {
                sql.append(index.getIndexType()).append(" ");
            }
            sql.append("INDEX").append(" ").append(index.getName()).append(" ").append("ON").append(" ").append(this.getTable());
            sql.append(" ").append("(").append(this.traverseNames(index.getColumns())).append(")");
            if (index.getOrder() != null) {
                sql.append(" ").append(index.getOrder());
            }
        }
        return sql.toString();
    }
}

