/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.view;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractDropSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropViewBuilder
extends AbstractDropSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DropViewBuilder.class);
    private final String view;
    private final String schema;

    public DropViewBuilder(ISqlDialect dialect, String schema, String view) {
        super(dialect);
        this.schema = schema;
        this.view = view;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateDrop(sql);
        this.generateView(sql);
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateView(StringBuilder sql) {
        sql.append(" ").append("VIEW").append(" ");
        if (this.schema != null) {
            String schemaName = this.isCaseSensitive() ? this.encapsulate(this.getView(), true) : this.getView();
            sql.append(schemaName).append(".");
        }
        String viewName = this.isCaseSensitive() ? this.encapsulate(this.getView(), true) : this.getView();
        sql.append(viewName);
    }

    public String getView() {
        return this.view;
    }
}

