/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.dialects;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.eclipse.dirigible.components.database.DatabaseSystem;
import org.eclipse.dirigible.components.database.DatabaseSystemDeterminer;
import org.eclipse.dirigible.components.database.DirigibleConnection;
import org.eclipse.dirigible.components.database.DirigibleDataSource;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.ISqlDialectProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDialectFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlDialectFactory.class);
    private static final ServiceLoader<ISqlDialectProvider> SQL_PROVIDERS = ServiceLoader.load(ISqlDialectProvider.class);
    private static final Map<DatabaseSystem, ISqlDialect> dialectsBySystem = Collections.synchronizedMap(new HashMap());

    public static ISqlDialect getDialect(DataSource dataSource) throws SQLException {
        if (dataSource instanceof DirigibleDataSource) {
            DirigibleDataSource dds = (DirigibleDataSource)dataSource;
            return SqlDialectFactory.getDialect(dds);
        }
        try (Connection connection = dataSource.getConnection();){
            ISqlDialect iSqlDialect = SqlDialectFactory.getDialect(connection);
            return iSqlDialect;
        }
    }

    public static ISqlDialect getDialect(Connection connection) throws SQLException {
        if (connection instanceof DirigibleConnection) {
            DirigibleConnection dc = (DirigibleConnection)connection;
            return SqlDialectFactory.getDialect(dc);
        }
        DatabaseMetaData metaData = connection.getMetaData();
        String jdbcUrl = metaData.getURL();
        String driver = metaData.getDriverName();
        DatabaseSystem databaseSystem = DatabaseSystemDeterminer.determine((String)jdbcUrl, (String)driver);
        return SqlDialectFactory.getDialect(databaseSystem);
    }

    public static ISqlDialect getDialect(DirigibleConnection connection) throws SQLException {
        return SqlDialectFactory.getDialect(connection.getDatabaseSystem());
    }

    public static ISqlDialect getDialect(DirigibleDataSource dataSource) throws SQLException {
        DatabaseSystem databaseSystem = dataSource.getDatabaseSystem();
        return SqlDialectFactory.getDialect(databaseSystem);
    }

    public static ISqlDialect getDialect(DatabaseSystem databaseSystem) throws SQLException {
        ISqlDialect dialect = dialectsBySystem.get(databaseSystem);
        if (dialect == null) {
            SqlDialectFactory.loadDefaultDialectsBySystem();
            dialect = dialectsBySystem.get(databaseSystem);
            if (dialect == null) {
                throw new IllegalStateException("Database dialect for [" + String.valueOf(databaseSystem) + "] is not available.");
            }
        }
        LOGGER.debug("Loaded dialect [{}] for [{}]", (Object)dialect, (Object)databaseSystem);
        return dialect;
    }

    private static void loadDefaultDialectsBySystem() {
        for (ISqlDialectProvider provider : SQL_PROVIDERS) {
            dialectsBySystem.put(provider.getDatabaseSystem(), provider.getDialect());
        }
    }

    static {
        SqlDialectFactory.loadDefaultDialectsBySystem();
    }
}

