/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.records;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractQuerySqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBuilder
extends AbstractQuerySqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SelectBuilder.class);
    private final List<String> columns = new ArrayList<String>();
    private final List<String> tables = new ArrayList<String>();
    private final List<String> joins = new ArrayList<String>();
    private final List<String> wheres = new ArrayList<String>();
    private final List<String> orders = new ArrayList<String>();
    private final List<String> groups = new ArrayList<String>();
    private final List<String> unions = new ArrayList<String>();
    private boolean distinct = false;
    private String having = null;
    private int limit = -1;
    private int offset = -1;
    private boolean forUpdate = false;
    private String schema = null;

    public SelectBuilder(ISqlDialect dialect) {
        super(dialect);
    }

    public SelectBuilder distinct() {
        if (logger.isTraceEnabled()) {
            logger.trace("distinct");
        }
        this.distinct = true;
        return this;
    }

    public SelectBuilder forUpdate() {
        if (logger.isTraceEnabled()) {
            logger.trace("forUpdate");
        }
        this.forUpdate = true;
        return this;
    }

    public SelectBuilder column(String column) {
        if (logger.isTraceEnabled()) {
            logger.trace("column: " + column);
        }
        this.columns.add(column);
        return this;
    }

    public SelectBuilder from(String table) {
        if (logger.isTraceEnabled()) {
            logger.trace("from: " + table);
        }
        return this.from(table, null);
    }

    public SelectBuilder from(String table, String alias) {
        if (logger.isTraceEnabled()) {
            logger.trace("from: " + table + ", alias: " + alias);
        }
        StringBuilder snippet = new StringBuilder();
        snippet.append(this.encapsulate(table));
        if (alias != null) {
            snippet.append(" ").append("AS").append(" ").append(this.encapsulate(alias));
        }
        this.tables.add(snippet.toString());
        return this;
    }

    public SelectBuilder schema(String schema) {
        if (logger.isTraceEnabled()) {
            logger.trace("schema: " + schema);
        }
        this.schema = schema;
        return this;
    }

    public SelectBuilder join(String table, String on) {
        if (logger.isTraceEnabled()) {
            logger.trace("join: " + table + ", on: " + on);
        }
        return this.join(table, on, null);
    }

    public SelectBuilder join(String table, String on, String alias) {
        if (logger.isTraceEnabled()) {
            logger.trace("join: " + table + ", on: " + on + ", alias: " + alias);
        }
        return this.genericJoin("INNER", table, on, alias);
    }

    public SelectBuilder innerJoin(String table, String on) {
        if (logger.isTraceEnabled()) {
            logger.trace("innerJoin: " + table + ", on: " + on);
        }
        return this.innerJoin(table, on, null);
    }

    public SelectBuilder innerJoin(String table, String on, String alias) {
        if (logger.isTraceEnabled()) {
            logger.trace("innerJoin: " + table + ", on: " + on + ", alias: " + alias);
        }
        return this.genericJoin("INNER", table, on, alias);
    }

    public SelectBuilder outerJoin(String table, String on) {
        if (logger.isTraceEnabled()) {
            logger.trace("outerJoin: " + table + ", on: " + on);
        }
        return this.outerJoin(table, on, null);
    }

    public SelectBuilder outerJoin(String table, String on, String alias) {
        if (logger.isTraceEnabled()) {
            logger.trace("outerJoin: " + table + ", on: " + on + ", alias: " + alias);
        }
        return this.genericJoin("OUTER", table, on, alias);
    }

    public SelectBuilder leftJoin(String table, String on) {
        if (logger.isTraceEnabled()) {
            logger.trace("leftJoin: " + table + ", on: " + on);
        }
        return this.leftJoin(table, on, null);
    }

    public SelectBuilder leftJoin(String table, String on, String alias) {
        if (logger.isTraceEnabled()) {
            logger.trace("leftJoin: " + table + ", on: " + on + ", alias: " + alias);
        }
        return this.genericJoin("LEFT", table, on, alias);
    }

    public SelectBuilder rightJoin(String table, String on) {
        if (logger.isTraceEnabled()) {
            logger.trace("rightJoin: " + table + ", on: " + on);
        }
        return this.rightJoin(table, on, null);
    }

    public SelectBuilder rightJoin(String table, String on, String alias) {
        if (logger.isTraceEnabled()) {
            logger.trace("rightJoin: " + table + ", on: " + on + ", alias: " + alias);
        }
        return this.genericJoin("RIGHT", table, on, alias);
    }

    public SelectBuilder fullJoin(String table, String on) {
        if (logger.isTraceEnabled()) {
            logger.trace("fullJoin: " + table + ", on: " + on);
        }
        return this.fullJoin(table, on, null);
    }

    public SelectBuilder fullJoin(String table, String on, String alias) {
        if (logger.isTraceEnabled()) {
            logger.trace("fullJoin: " + table + ", on: " + on + ", alias: " + alias);
        }
        return this.genericJoin("FULL", table, on, alias);
    }

    public SelectBuilder genericJoin(String type, String table, String on, String alias) {
        if (logger.isTraceEnabled()) {
            logger.trace("genericJoin: " + type + ", table: " + table + ", on: " + on + ", alias: " + alias);
        }
        StringBuilder snippet = new StringBuilder();
        String schemaName = this.encapsulate(this.schema, true);
        String tableName = this.encapsulate(table, true);
        if (this.schema != null) {
            snippet.append(type).append(" ").append("JOIN").append(" ").append(schemaName).append(".").append(tableName);
        } else {
            snippet.append(type).append(" ").append("JOIN").append(" ").append(tableName);
        }
        if (alias != null) {
            String aliasName = this.encapsulate(alias);
            snippet.append(" ").append("AS").append(" ").append(aliasName);
        }
        snippet.append(" ").append("ON").append(" ").append(this.traverseOn(on));
        this.joins.add(snippet.toString());
        return this;
    }

    public SelectBuilder where(String condition) {
        if (logger.isTraceEnabled()) {
            logger.trace("where: " + condition);
        }
        this.wheres.add("(" + condition + ")");
        return this;
    }

    public SelectBuilder order(String column) {
        if (logger.isTraceEnabled()) {
            logger.trace("order: " + column);
        }
        String columnName = this.encapsulate(column);
        return this.order(columnName, true);
    }

    public SelectBuilder order(String column, boolean asc) {
        if (logger.isTraceEnabled()) {
            logger.trace("order: " + column + ", asc: " + asc);
        }
        String columnName = this.encapsulate(column);
        if (asc) {
            this.orders.add(columnName + " ASC");
        } else {
            this.orders.add(columnName + " DESC");
        }
        return this;
    }

    public SelectBuilder group(String column) {
        if (logger.isTraceEnabled()) {
            logger.trace("group: " + column);
        }
        this.groups.add(column);
        return this;
    }

    public SelectBuilder limit(int limit) {
        if (logger.isTraceEnabled()) {
            logger.trace("limit: " + limit);
        }
        this.limit = limit;
        return this;
    }

    public SelectBuilder limit(Double limit) {
        if (logger.isTraceEnabled()) {
            logger.trace("limit: " + limit);
        }
        return this.limit(limit.intValue());
    }

    public SelectBuilder offset(int offset) {
        if (logger.isTraceEnabled()) {
            logger.trace("offset: " + offset);
        }
        this.offset = offset;
        return this;
    }

    public SelectBuilder offset(Double offset) {
        if (logger.isTraceEnabled()) {
            logger.trace("offset: " + offset);
        }
        return this.offset(offset.intValue());
    }

    public SelectBuilder having(String having) {
        if (logger.isTraceEnabled()) {
            logger.trace("having: " + having);
        }
        this.having = having;
        return this;
    }

    public SelectBuilder union(String select) {
        if (logger.isTraceEnabled()) {
            logger.trace("union: " + select);
        }
        this.unions.add(select);
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateSelect(sql);
        this.generateDistinct(sql);
        this.generateColumns(sql);
        this.generateTables(sql);
        this.generateJoins(sql);
        this.generateWhere(sql, this.wheres);
        this.generateGroupBy(sql);
        this.generateHaving(sql);
        this.generateOrderBy(sql, this.orders);
        this.generateLimitAndOffset(sql, this.limit, this.offset);
        this.generateUnion(sql);
        this.generateForUpdate(sql);
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateUnion(StringBuilder sql) {
        if (!this.unions.isEmpty()) {
            sql.append(" ").append("UNION").append(" ").append(this.traverseUnions());
        }
    }

    protected void generateHaving(StringBuilder sql) {
        if (this.having != null) {
            sql.append(" ").append("HAVING").append(" ").append(this.traverseHaving(this.having));
        }
    }

    protected void generateGroupBy(StringBuilder sql) {
        if (!this.groups.isEmpty()) {
            sql.append(" ").append("GROUP BY").append(" ").append(this.traverseGroups());
        }
    }

    protected void generateJoins(StringBuilder sql) {
        if (!this.joins.isEmpty()) {
            sql.append(" ").append(this.traverseJoins());
        }
    }

    protected void generateTables(StringBuilder sql) {
        sql.append(" ").append("FROM").append(" ").append(this.traverseTables());
    }

    protected void generateColumns(StringBuilder sql) {
        sql.append(" ").append(this.traverseColumns());
    }

    protected void generateDistinct(StringBuilder sql) {
        if (this.distinct) {
            sql.append(" ").append("DISTINCT");
        }
    }

    protected void generateForUpdate(StringBuilder sql) {
        if (this.forUpdate) {
            sql.append(" ").append("FOR UPDATE");
        }
    }

    protected String traverseColumns() {
        if (!this.columns.isEmpty()) {
            StringBuilder snippet = new StringBuilder();
            for (String column : this.columns) {
                String columnName = this.encapsulate(column);
                snippet.append(columnName).append(",").append(" ");
            }
            return snippet.substring(0, snippet.length() - 2);
        }
        return "*";
    }

    protected String traverseTables() {
        StringBuilder snippet = new StringBuilder();
        for (String table : this.tables) {
            String schemaName = this.encapsulate(this.schema, true);
            String tableName = this.encapsulate(table, true);
            if (this.schema != null) {
                snippet.append(schemaName).append(".").append(tableName).append(",").append(" ");
                continue;
            }
            snippet.append(tableName).append(",").append(" ");
        }
        return snippet.substring(0, snippet.length() - 2);
    }

    protected String traverseJoins() {
        StringBuilder snippet = new StringBuilder();
        for (String join : this.joins) {
            snippet.append(join).append(",").append(" ");
        }
        return snippet.substring(0, snippet.length() - 2);
    }

    protected String traverseGroups() {
        StringBuilder snippet = new StringBuilder();
        for (String group : this.groups) {
            String groupName = this.encapsulate(group);
            snippet.append(groupName).append(",").append(" ");
        }
        return snippet.substring(0, snippet.length() - 2);
    }

    protected String traverseUnions() {
        StringBuilder snippet = new StringBuilder();
        for (String unionSQL : this.unions) {
            snippet.append(unionSQL).append(" ");
        }
        return snippet.substring(0, snippet.length() - 1);
    }

    protected void generateSelect(StringBuilder sql) {
        sql.append("SELECT");
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public List<String> getJoins() {
        return this.joins;
    }

    public List<String> getWheres() {
        return this.wheres;
    }

    public List<String> getOrders() {
        return this.orders;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<String> getUnions() {
        return this.unions;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getHaving() {
        return this.having;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }
}

