/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.schema;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractDropSqlBuilder;
import org.eclipse.dirigible.database.sql.builders.schema.CreateSchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropSchemaBuilder
extends AbstractDropSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CreateSchemaBuilder.class);
    private final String name;
    private boolean cascade = false;

    public DropSchemaBuilder(ISqlDialect dialect, String name) {
        super(dialect);
        this.name = name;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateDrop(sql);
        this.generateSchema(sql);
        if (this.cascade) {
            sql.append(" ").append("CASCADE");
        }
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateSchema(StringBuilder sql) {
        String schemaName = this.encapsulate(this.getName(), true);
        sql.append(" ").append("SCHEMA").append(" ").append(schemaName);
    }

    public String getName() {
        return this.name;
    }

    public DropSchemaBuilder cascade(boolean cascade) {
        this.cascade = cascade;
        return this;
    }
}

