/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.synonym;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractCreateSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSynonymBuilder
extends AbstractCreateSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CreateSynonymBuilder.class);
    private String synonym = null;
    private String source = null;

    public CreateSynonymBuilder(ISqlDialect dialect, String synonym) {
        super(dialect);
        this.synonym = synonym;
    }

    public CreateSynonymBuilder forSource(String source) {
        if (logger.isTraceEnabled()) {
            logger.trace("source: " + source);
        }
        this.source = source;
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateCreate(sql);
        this.generateSynonym(sql);
        this.generateSource(sql);
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateSynonym(StringBuilder sql) {
        String synonymName = this.encapsulate(this.getSynonym(), true);
        sql.append(" ").append("SYNONYM").append(" ").append(synonymName);
    }

    protected void generateSource(StringBuilder sql) {
        String sourceName = this.encapsulate(this.getSource(), true);
        sql.append(" ").append("FOR").append(" ").append(sourceName);
    }

    public String getSynonym() {
        return this.synonym;
    }

    public String getSource() {
        return this.source;
    }
}

