/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.table;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractDropSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableBuilder
extends AbstractDropSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DropTableBuilder.class);
    private String table = null;
    private boolean cascade = false;

    public DropTableBuilder(ISqlDialect dialect, String table) {
        super(dialect);
        this.table = table;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateDrop(sql);
        this.generateTable(sql);
        if (this.cascade) {
            sql.append(" ").append("CASCADE");
        }
        String generated = sql.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("generated: " + generated);
        }
        return generated;
    }

    protected void generateTable(StringBuilder sql) {
        String tableName = this.encapsulate(this.getTable(), true);
        sql.append(" ").append("TABLE").append(" ").append(tableName);
    }

    public String getTable() {
        return this.table;
    }

    public DropTableBuilder cascade(boolean cascade) {
        this.cascade = cascade;
        return this;
    }
}

