/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.user;

import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractCreateSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateUserBuilder
extends AbstractCreateSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CreateUserBuilder.class);
    private final String userId;
    private final String password;

    public CreateUserBuilder(ISqlDialect dialect, String userId, String password) {
        super(dialect);
        this.userId = userId;
        this.password = password;
    }

    @Override
    public String generate() {
        String generated = this.generateCreateUserStatement(this.userId, this.password);
        logger.trace("generated: " + generated);
        return generated;
    }

    protected String generateCreateUserStatement(String user, String pass) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE USER ").append(this.getEscapeSymbol()).append(user).append(this.getEscapeSymbol()).append(" ").append(" PASSWORD ").append(this.getPasswordEscapeSymbol()).append(pass).append(this.getPasswordEscapeSymbol());
        return sql.toString();
    }

    protected char getPasswordEscapeSymbol() {
        return '\'';
    }
}

