/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.database.sql.builders.records;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.database.sql.ISqlDialect;
import org.eclipse.dirigible.database.sql.builders.AbstractQuerySqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteBuilder
extends AbstractQuerySqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DeleteBuilder.class);
    private String table;
    private List<String> wheres = new ArrayList<String>();

    public DeleteBuilder(ISqlDialect dialect) {
        super(dialect);
    }

    public DeleteBuilder from(String table) {
        logger.trace("from: " + table);
        this.table = table;
        return this;
    }

    public DeleteBuilder where(String condition) {
        logger.trace("where: " + condition);
        this.wheres.add("(" + condition + ")");
        return this;
    }

    @Override
    public String generate() {
        StringBuilder sql = new StringBuilder();
        this.generateDelete(sql);
        this.generateTable(sql);
        this.generateWhere(sql, this.wheres);
        String generated = sql.toString();
        logger.trace("generated: " + generated);
        return generated;
    }

    protected void generateTable(StringBuilder sql) {
        sql.append(" ").append("FROM").append(" ").append(this.table);
    }

    protected void generateDelete(StringBuilder sql) {
        sql.append("DELETE");
    }

    public String getTable() {
        return this.table;
    }

    public List<String> getWheres() {
        return this.wheres;
    }
}

